% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_task_classif_st.R
\name{as_task_classif_st}
\alias{as_task_classif_st}
\alias{as_task_classif_st.TaskClassifST}
\alias{as_task_classif_st.data.frame}
\alias{as_task_classif_st.DataBackend}
\alias{as_task_classif_st.sf}
\title{Convert to a Spatiotemporal Classification Task}
\usage{
as_task_classif_st(x, ...)

\method{as_task_classif_st}{TaskClassifST}(x, clone = FALSE, ...)

\method{as_task_classif_st}{data.frame}(
  x,
  target = NULL,
  id = deparse(substitute(x)),
  positive = NULL,
  crs = NA,
  coords_as_features = FALSE,
  coordinate_names = NA,
  ...
)

\method{as_task_classif_st}{DataBackend}(
  x,
  target = NULL,
  id = deparse(substitute(x)),
  positive = NULL,
  crs = NA,
  coords_as_features = FALSE,
  coordinate_names = c("x", "y"),
  ...
)

\method{as_task_classif_st}{sf}(
  x,
  target = NULL,
  id = deparse(substitute(x)),
  positive = NULL,
  coords_as_features = FALSE,
  ...
)
}
\arguments{
\item{x}{(\code{any})\cr
Object to convert.}

\item{...}{(\code{any})\cr
Additional arguments.}

\item{clone}{(\code{logical(1)})\cr
If \code{TRUE}, ensures that the returned object is not the same as the input \code{x}.}

\item{target}{(\code{character(1)})\cr
Name of the target column.}

\item{id}{(\code{character(1)})\cr
Id for the new task.
Defaults to the (deparsed and substituted) name of \code{x}.}

\item{positive}{(\code{character(1)})\cr
Level of the positive class. See \link[mlr3]{TaskClassif}.}

\item{crs}{\verb{[character(1)]}\cr
Coordinate reference system. Either a PROJ string or an
\href{https://epsg.io/}{EPSG} code.}

\item{coords_as_features}{\verb{[logical(1)]}\cr
Whether the coordinates should also be used as features.}

\item{coordinate_names}{(\code{character()})\cr
The variables names of the coordinates in the data.}
}
\value{
\link{TaskClassifST}.
}
\description{
Convert an object to a \link{TaskClassifST}.
This is a S3 generic for the following objects:
\enumerate{
\item \link{TaskClassifST}: ensure the identity
\item \code{\link[=data.frame]{data.frame()}} and \link{DataBackend}: provides an alternative to the
constructor of \link{TaskClassifST}.
\item \link[sf:sf]{sf::sf}.
}
}
\examples{
library("mlr3")
data("ecuador", package = "mlr3spatiotempcv")

# data.frame
as_task_classif_st(ecuador, target = "slides", positive = "TRUE",
  coords_as_features = FALSE,
  crs = "+proj=utm +zone=17 +south +datum=WGS84 +units=m +no_defs",
  coordinate_names = c("x", "y"))

# sf
ecuador_sf = sf::st_as_sf(ecuador, coords = c("x", "y"), crs = 32717)
as_task_classif_st(ecuador_sf, target = "slides", positive = "TRUE")

# TaskClassifST
task = tsk("ecuador")
as_task_classif_st(task)
}
