% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataDescriptor.R
\name{as_data_descriptor}
\alias{as_data_descriptor}
\title{Convert to Data Descriptor}
\usage{
as_data_descriptor(x, dataset_shapes, ...)
}
\arguments{
\item{x}{(any)\cr
Object to convert.}

\item{dataset_shapes}{(named \code{list()} of (\code{integer()} or \code{NULL}))\cr
The shapes of the output.
Names are the elements of the list returned by the dataset.
If the shape is not \code{NULL} (unknown, e.g. for images of different sizes) the first dimension must be \code{NA} to
indicate the batch dimension.}

\item{...}{(any)\cr
Further arguments passed to the \code{\link{DataDescriptor}} constructor.}
}
\description{
Converts the input to a \code{\link{DataDescriptor}}.
}
\examples{
\dontshow{if (torch::torch_is_installed()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
ds = dataset("example",
  initialize = function() self$iris = iris[, -5],
  .getitem = function(i) list(x = torch_tensor(as.numeric(self$iris[i, ]))),
  .length = function() nrow(self$iris)
)()
as_data_descriptor(ds, list(x = c(NA, 4L)))

# if the dataset has a .getbatch method, the shapes are inferred
ds2 = dataset("example",
  initialize = function() self$iris = iris[, -5],
  .getbatch = function(i) list(x = torch_tensor(as.matrix(self$iris[i, ]))),
  .length = function() nrow(self$iris)
)()
as_data_descriptor(ds2)
\dontshow{\}) # examplesIf}
}
