% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ResampleResult.R
\name{autoplot.ResampleResult}
\alias{autoplot.ResampleResult}
\title{Plot for ResampleResult}
\usage{
\method{autoplot}{ResampleResult}(object, type = "boxplot", measure = NULL, predict_sets = "test", ...)
}
\arguments{
\item{object}{(\link[mlr3:ResampleResult]{mlr3::ResampleResult}).}

\item{type}{(character(1)):\cr
Type of the plot. See description.}

\item{measure}{(\link[mlr3:Measure]{mlr3::Measure}).}

\item{predict_sets}{(\code{character()})\cr
Only for \code{type} set to \code{"prediction"}.
Which points should be shown in the plot?
Can be a subset of (\code{"train"}, \code{"test"}) or empty.}

\item{...}{(\code{any}):
Additional arguments, passed down to the respective \code{geom}.}
}
\value{
\code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} object.
}
\description{
Generates plots for \link[mlr3:ResampleResult]{mlr3::ResampleResult}, depending on argument \code{type}:
\itemize{
\item \code{"boxplot"} (default): Boxplot of performance measures.
\item \code{"histogram"}: Histogram of performance measures.
\item \code{"roc"}: ROC curve (1 - specificity on x, sensitivity on y).
The predictions of the individual \link[mlr3:Resampling]{mlr3::Resampling}s are merged prior to calculating the ROC curve
(micro averaged). Requires package \CRANpkg{precrec}.
\item \code{"prc"}: Precision recall curve. See \code{"roc"}.
\item \code{"prediction"}: Plots the learner prediction for a grid of points.
Needs models to be stored. Set \code{store_models = TRUE} for \verb{[mlr3::resample]}.
For classification, we support tasks with exactly two features and learners with \verb{predict_type=} set to \code{"response"} or \code{"prob"}.
For regression, we support tasks with one or two features.
For tasks with one feature we can print confidence bounds if the predict type of the learner was set to \code{"se"}.
For tasks with two features the predict type will be ignored.
}
}
\examples{
library(mlr3)
library(mlr3viz)

task = tsk("sonar")
learner = lrn("classif.rpart", predict_type = "prob")
resampling = rsmp("cv")
object = resample(task, learner, resampling)

head(fortify(object))

# Default: boxplot
autoplot(object)

# Histogram
autoplot(object, type = "histogram", bins = 30)

# ROC curve, averaged over resampling folds:
autoplot(object, type = "roc")

# ROC curve of joint prediction object:
autoplot(object$prediction(), type = "roc")

# Precision Recall Curve
autoplot(object, type = "prc")

# Prediction Plot
task = tsk("iris")$select(c("Sepal.Length", "Sepal.Width"))
resampling = rsmp("cv", folds = 3)
object = resample(task, learner, resampling, store_models = TRUE)
autoplot(object, type = "prediction")
}
