% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/properties.R
\name{getCPOClass}
\alias{getCPOClass}
\title{Get the CPO Class}
\usage{
getCPOClass(cpo)
}
\arguments{
\item{cpo}{[\code{\link{CPOConstructor}} | \code{\link{CPO}} | \code{\link{CPOTrained}}]\cr
The CPO.}
}
\value{
[\code{character(1)}]. \dQuote{CPOConstructor} if the given object is a \code{\link{CPOConstructor}},
  \dQuote{CPO} for a \code{\link{CPO}},
  \dQuote{CPOInverter} for a \code{\link{CPOInverter}} only,
  \dQuote{CPORetrafo} for a \code{\link{CPORetrafo}} object (which may have inverter capabilities, see
  \code{link{getCPOTrainedCapability}}),
  \dQuote{NULLCPO} for a \code{\link{NULLCPO}}.
}
\description{
Gets the relevant \code{\link{CPO}} class that distinguishes between steps in a CPO's
lifecycle.

There is a fundamental distinction between \code{\link{CPO}} objects
and \code{\link{CPOTrained}} objects, the latter of which can provide either
retrafo or inverter functionality, or both. \code{CPOTrained} are subclassed into
\code{\link{CPOInverter}} (only inverter functionality), or
\code{\link{CPORetrafo}} (retrafo, possibly also inverter). To get more information
about a \code{\link{CPORetrafo}} object's capabilities, use \code{\link{getCPOTrainedCapability}}.
}
\seealso{
Other getters and setters: \code{\link{CPO}},
  \code{\link{getCPOAffect}},
  \code{\link{getCPOConstructor}}, \code{\link{getCPOId}},
  \code{\link{getCPOName}},
  \code{\link{getCPOOperatingType}},
  \code{\link{getCPOPredictType}},
  \code{\link{getCPOProperties}},
  \code{\link{getCPOTrainedCPO}},
  \code{\link{getCPOTrainedCapability}},
  \code{\link{setCPOId}}

Other retrafo related: \code{\link{CPOTrained}},
  \code{\link{NULLCPO}}, \code{\link{\%>>\%}},
  \code{\link{applyCPO}}, \code{\link{as.list.CPO}},
  \code{\link{clearRI}}, \code{\link{getCPOName}},
  \code{\link{getCPOOperatingType}},
  \code{\link{getCPOPredictType}},
  \code{\link{getCPOProperties}},
  \code{\link{getCPOTrainedCPO}},
  \code{\link{getCPOTrainedCapability}},
  \code{\link{getCPOTrainedState}},
  \code{\link{is.retrafo}},
  \code{\link{makeCPOTrainedFromState}},
  \code{\link{pipeCPO}}, \code{\link{print.CPOConstructor}}

Other inverter related: \code{\link{CPOTrained}},
  \code{\link{NULLCPO}}, \code{\link{\%>>\%}},
  \code{\link{applyCPO}}, \code{\link{as.list.CPO}},
  \code{\link{clearRI}}, \code{\link{getCPOName}},
  \code{\link{getCPOOperatingType}},
  \code{\link{getCPOPredictType}},
  \code{\link{getCPOProperties}},
  \code{\link{getCPOTrainedCPO}},
  \code{\link{getCPOTrainedCapability}},
  \code{\link{getCPOTrainedState}},
  \code{\link{is.inverter}},
  \code{\link{makeCPOTrainedFromState}},
  \code{\link{pipeCPO}}, \code{\link{print.CPOConstructor}}

Other CPOConstructor related: \code{\link{CPOConstructor}},
  \code{\link{getCPOConstructor}},
  \code{\link{getCPOName}}, \code{\link{identicalCPO}},
  \code{\link{makeCPO}}, \code{\link{print.CPOConstructor}}

Other CPO classifications: \code{\link{CPO}},
  \code{\link{getCPOOperatingType}},
  \code{\link{getCPOTrainedCapability}}

Other CPO lifecycle related: \code{\link{CPOConstructor}},
  \code{\link{CPOLearner}}, \code{\link{CPOTrained}},
  \code{\link{CPO}}, \code{\link{NULLCPO}},
  \code{\link{\%>>\%}}, \code{\link{attachCPO}},
  \code{\link{composeCPO}},
  \code{\link{getCPOConstructor}},
  \code{\link{getCPOTrainedCPO}},
  \code{\link{identicalCPO}}, \code{\link{makeCPO}}
}
\concept{CPO classifications}
\concept{CPO lifecycle related}
\concept{CPOConstructor related}
\concept{getters and setters}
\concept{inverter related}
\concept{retrafo related}
