% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/properties.R
\name{getCPOTrainedCPO}
\alias{getCPOTrainedCPO}
\title{Get CPO Used to Train a Retrafo / Inverter}
\usage{
getCPOTrainedCPO(cpo)
}
\arguments{
\item{cpo}{[\code{\link{CPOTrained}}]\cr
The Retrafo or Inverter to get the original \code{\link{CPO}} from.}
}
\value{
[\code{\link{CPO}}]. The original \code{\link{CPO}}.
}
\description{
Get the \code{\link{CPO}} used to create a \code{\link{CPOTrained}} object. The
retrieved \code{\link{CPO}} will usually have all its hyperparameters and \code{affect.*}
settings set to the values used to create the particular \code{\link{CPOTrained}} object.
The only case where this is \emph{not true} is if \code{cpo} is a \code{\link{CPOTrained}}
that was created using \code{\link{makeCPOTrainedFromState}}.
}
\seealso{
Other getters and setters: \code{\link{CPO}},
  \code{\link{getCPOAffect}}, \code{\link{getCPOClass}},
  \code{\link{getCPOConstructor}}, \code{\link{getCPOId}},
  \code{\link{getCPOName}},
  \code{\link{getCPOOperatingType}},
  \code{\link{getCPOPredictType}},
  \code{\link{getCPOProperties}},
  \code{\link{getCPOTrainedCapability}},
  \code{\link{setCPOId}}

Other retrafo related: \code{\link{CPOTrained}},
  \code{\link{NULLCPO}}, \code{\link{\%>>\%}},
  \code{\link{applyCPO}}, \code{\link{as.list.CPO}},
  \code{\link{clearRI}}, \code{\link{getCPOClass}},
  \code{\link{getCPOName}},
  \code{\link{getCPOOperatingType}},
  \code{\link{getCPOPredictType}},
  \code{\link{getCPOProperties}},
  \code{\link{getCPOTrainedCapability}},
  \code{\link{getCPOTrainedState}},
  \code{\link{is.retrafo}},
  \code{\link{makeCPOTrainedFromState}},
  \code{\link{pipeCPO}}, \code{\link{print.CPOConstructor}}

Other inverter related: \code{\link{CPOTrained}},
  \code{\link{NULLCPO}}, \code{\link{\%>>\%}},
  \code{\link{applyCPO}}, \code{\link{as.list.CPO}},
  \code{\link{clearRI}}, \code{\link{getCPOClass}},
  \code{\link{getCPOName}},
  \code{\link{getCPOOperatingType}},
  \code{\link{getCPOPredictType}},
  \code{\link{getCPOProperties}},
  \code{\link{getCPOTrainedCapability}},
  \code{\link{getCPOTrainedState}},
  \code{\link{is.inverter}},
  \code{\link{makeCPOTrainedFromState}},
  \code{\link{pipeCPO}}, \code{\link{print.CPOConstructor}}

Other CPO lifecycle related: \code{\link{CPOConstructor}},
  \code{\link{CPOLearner}}, \code{\link{CPOTrained}},
  \code{\link{CPO}}, \code{\link{NULLCPO}},
  \code{\link{\%>>\%}}, \code{\link{attachCPO}},
  \code{\link{composeCPO}}, \code{\link{getCPOClass}},
  \code{\link{getCPOConstructor}},
  \code{\link{identicalCPO}}, \code{\link{makeCPO}}
}
\concept{CPO lifecycle related}
\concept{getters and setters}
\concept{inverter related}
\concept{retrafo related}
