% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{LocLinear}
\alias{LocLinear}
\title{Local linear Regression}
\usage{
LocLinear(bw, t, y, X, db_kernel = 0L, deriv2 = 0L, scb = 0L)
}
\arguments{
\item{bw}{double, bandwidth}

\item{t}{vector, time, 1:n/n}

\item{y}{vector, response series to be tested for long memory in the next step}

\item{X}{matrix, covariates matrix}

\item{db_kernel}{bool, whether to use jackknife kernel, default 0}

\item{deriv2}{bool,whether to return second-order derivative, default 0}

\item{scb}{bool, whether to use the result for further calculation of simultaneous confidence bands.}
}
\value{
a list of results
\itemize{
\item mu: the estimated trend
\item beta0: time varying coefficient
\item X_reg: a matrix whose j'th row is \mjseqn{x_j^T\hat{M}(t_j)}
\item t: 1:n/n
\item bw: bandwidth used
\item X: covariates matrix
\item y: response
\item n: sample size
\item p: dimension of covariates including the intercept
\item invM: inversion of M matrix, when scb = 1
}
}
\description{
Local linear estimates for time varying coefficients
}
\details{
The time varying coefficients are estimated by
\mjsdeqn{(\hat{\boldsymbol{\beta}}_{b_{n}}(t), \hat{\boldsymbol{\beta}}_{b_{n}}^{\prime}(t)) = \mathbf{arg min}_{\eta_{0},\eta_{1}}[\sum_{i=1}^{n}\{y_{i}-\mathbf{x}_{i}^{\mathrm{T}}\eta_{0}-\mathbf{x}_{i}^{\mathrm{T}} \eta_{1}(t_{i}-t)\}^{2} \boldsymbol{K}_{b_{n}}(t_{i}-t)]}
where beta0 is \mjseqn{\hat{\boldsymbol{\beta}}_{b_{n}}(t)}, mu is \mjseqn{X^T \hat{\boldsymbol{\beta}}_{b_{n}}(t)}
}
\examples{
param = list(d = -0.2, heter = 2, tvd = 0,
 tw = 0.8, rate = 0.1, cur = 1, center = 0.3,
  ma_rate =  0, cov_tw =  0.2, cov_rate = 0.1,
   cov_center = 0.1, all_tw  = 1, cov_trend = 0.7)
n = 500
t = (1:n)/n
data = Qct_reg(n, param)
result = LocLinear(0.2, t, data$y, data$x)
}
\references{
Zhou, Z., & Wu, W. B. (2010). Simultaneous inference of linear models with time varying coefficients. Journal of the Royal Statistical Society: Series B (Statistical Methodology), 72(4), 513-531.
}
