% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/learner_surv_xgboost_aft.R
\name{LearnerSurvXgboostAft}
\alias{LearnerSurvXgboostAft}
\title{R6 Class to construct a Xgboost survival learner for accelerated
failure time models}
\description{
The \code{LearnerSurvXgboostAft} class is the interface to accelerated failure
time models with the \code{xgboost} R package for use with the \code{mlexperiments}
package.
}
\details{
Optimization metric: needs to be specified with the learner parameter
\code{eval_metric}.
Can be used with
\itemize{
\item \link[mlexperiments:MLTuneParameters]{mlexperiments::MLTuneParameters}
\item \link[mlexperiments:MLCrossValidation]{mlexperiments::MLCrossValidation}
\item \link[mlexperiments:MLNestedCV]{mlexperiments::MLNestedCV}
}

Also see the official xgboost documentation on aft models:
\url{https://xgboost.readthedocs.io/en/stable/tutorials/aft_survival_analysis.html}
}
\examples{
\donttest{# execution time >2.5 sec
# survival analysis
Sys.setenv("OMP_THREAD_LIMIT" = 2)

dataset <- survival::colon |>
  data.table::as.data.table() |>
  na.omit()
dataset <- dataset[get("etype") == 2, ]

seed <- 123
surv_cols <- c("status", "time", "rx")

feature_cols <- colnames(dataset)[3:(ncol(dataset) - 1)]

param_list_xgboost <- expand.grid(
  objective = "survival:aft",
  eval_metric = "aft-nloglik",
  subsample = seq(0.6, 1, .2),
  colsample_bytree = seq(0.6, 1, .2),
  min_child_weight = seq(1, 5, 4),
  learning_rate = c(0.1, 0.2),
  max_depth = seq(1, 5, 4)
)
ncores <- 2L

split_vector <- splitTools::multi_strata(
  df = dataset[, .SD, .SDcols = surv_cols],
  strategy = "kmeans",
  k = 4
)

train_x <- model.matrix(
  ~ -1 + .,
  dataset[, .SD, .SDcols = setdiff(feature_cols, surv_cols[1:2])]
)
train_y <- survival::Surv(
  event = (dataset[, get("status")] |>
             as.character() |>
             as.integer()),
  time = dataset[, get("time")],
  type = "right"
)

fold_list <- splitTools::create_folds(
  y = split_vector,
  k = 3,
  type = "stratified",
  seed = seed
)

surv_xgboost_aft_optimizer <- mlexperiments::MLCrossValidation$new(
  learner = LearnerSurvXgboostAft$new(
    metric_optimization_higher_better = FALSE
  ),
  fold_list = fold_list,
  ncores = ncores,
  seed = seed
)
surv_xgboost_aft_optimizer$learner_args <- c(as.list(
  param_list_xgboost[1, ]),
  nrounds = 45L
)
surv_xgboost_aft_optimizer$performance_metric <- c_index

# set data
surv_xgboost_aft_optimizer$set_data(
  x = train_x,
  y = train_y
)

surv_xgboost_aft_optimizer$execute()
}


## ------------------------------------------------
## Method `LearnerSurvXgboostAft$new`
## ------------------------------------------------

LearnerSurvXgboostAft$new(metric_optimization_higher_better = FALSE)

}
\seealso{
\code{\link[xgboost:xgb.train]{xgboost::xgb.train()}}, \code{\link[xgboost:xgb.cv]{xgboost::xgb.cv()}}
}
\section{Super classes}{
\code{\link[mlexperiments:MLLearnerBase]{mlexperiments::MLLearnerBase}} -> \code{\link[mllrnrs:LearnerXgboost]{mllrnrs::LearnerXgboost}} -> \code{LearnerSurvXgboostAft}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-LearnerSurvXgboostAft-new}{\code{LearnerSurvXgboostAft$new()}}
\item \href{#method-LearnerSurvXgboostAft-clone}{\code{LearnerSurvXgboostAft$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlexperiments" data-topic="MLLearnerBase" data-id="bayesian_scoring_function"><a href='../../mlexperiments/html/MLLearnerBase.html#method-MLLearnerBase-bayesian_scoring_function'><code>mlexperiments::MLLearnerBase$bayesian_scoring_function()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlexperiments" data-topic="MLLearnerBase" data-id="cross_validation"><a href='../../mlexperiments/html/MLLearnerBase.html#method-MLLearnerBase-cross_validation'><code>mlexperiments::MLLearnerBase$cross_validation()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlexperiments" data-topic="MLLearnerBase" data-id="fit"><a href='../../mlexperiments/html/MLLearnerBase.html#method-MLLearnerBase-fit'><code>mlexperiments::MLLearnerBase$fit()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlexperiments" data-topic="MLLearnerBase" data-id="predict"><a href='../../mlexperiments/html/MLLearnerBase.html#method-MLLearnerBase-predict'><code>mlexperiments::MLLearnerBase$predict()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LearnerSurvXgboostAft-new"></a>}}
\if{latex}{\out{\hypertarget{method-LearnerSurvXgboostAft-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{LearnerSurvXgboostAft} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerSurvXgboostAft$new(metric_optimization_higher_better)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{metric_optimization_higher_better}}{A logical. Defines the direction
of the optimization metric used throughout the hyperparameter
optimization.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{LearnerSurvXgboostAft} R6 object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{LearnerSurvXgboostAft$new(metric_optimization_higher_better = FALSE)

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LearnerSurvXgboostAft-clone"></a>}}
\if{latex}{\out{\hypertarget{method-LearnerSurvXgboostAft-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerSurvXgboostAft$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
