% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auc_roc.R
\name{auc_roc}
\alias{auc_roc}
\title{Area Under the ROC Curve}
\usage{
auc_roc(preds, actuals, returnDT = FALSE)
}
\arguments{
\item{preds}{A vector of prediction values}

\item{actuals}{A vector of actuals values (numeric or ordered factor)}

\item{returnDT}{If TRUE, a data.table of (FalsePositiveRate, TruePositiveRate) pairs is returned, otherwise AUC ROC score is returned}
}
\description{
Calculates Area Under the ROC Curve
}
\details{
If \code{returnDT=FALSE}, returns Area Under the ROC Curve.If \code{returnDT=TRUE}, returns a data.table object with
False Positive Rate and True Positive Rate for plotting the ROC curve.
}
\examples{
library(data.table)
preds <- c(.1, .3, .3, .9)
actuals <- c(0, 0, 1, 1)
auc_roc(preds, actuals)
auc_roc(preds, actuals, returnDT=TRUE)
}
\references{
\url{https://en.wikipedia.org/wiki/Receiver_operating_characteristic#Area_under_the_curve}
}
