% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prctilemlx.R
\name{prctilemlx}
\alias{prctilemlx}
\title{Percentiles of the empiricial distribution of longitudinal data}
\usage{
prctilemlx(r, band = list(number = 8, level = 80), y.lim = NULL,
  plot = TRUE)
}
\arguments{
\item{r}{a data frame with a column \samp{id}, a column \samp{time} and a column with values.
The times should be the same for each individual.}

\item{band}{a list with two fields
\itemize{
  \item \code{number} the number of intervals (i.e. the number of percentiles minus 1).
  \item \code{level} the largest interval (i.e. the difference between the lowest and the highest percentile).
}}

\item{y.lim}{the use of y.lim is deprecated. You can use prctile(...)+ylim(...) instead.}

\item{plot}{if \code{TRUE} the empirical distribution is displayed, if \code{FALSE}
the values of the percentiles are returned}
}
\value{
a list with fields:
\itemize{
  \item proba a vector of probabilities of length \code{band$number+1} 
  \item color a vector of colors used for the plot of length \code{band$number}
  \item y a data frame with the values of the empirical percentiles computed at each time point
}
}
\description{
Compute and display percentiles of the empiricial distribution of longitudinal data.
}
\details{
See http://simulx.webpopix.org/mlxr/prctilemlx/ for more details.
}
\examples{
\dontrun{
  myModel <- inlineModel("
  [LONGITUDINAL]
  input = {ka, V, Cl}
  EQUATION:
  C = pkmodel(ka,V,Cl)
  
  [INDIVIDUAL]
  input = {ka_pop, V_pop, Cl_pop, omega_ka, omega_V, omega_Cl}
  DEFINITION:
  ka = {distribution=lognormal, reference=ka_pop, sd=omega_ka}
  V  = {distribution=lognormal, reference=V_pop,  sd=omega_V }
  Cl = {distribution=lognormal, reference=Cl_pop, sd=omega_Cl}
  ")
  
  N=2000
  
  pop.param   <- c(
    ka_pop  = 1,    omega_ka  = 0.5,
    V_pop   = 10,   omega_V   = 0.4,
    Cl_pop  = 1,    omega_Cl  = 0.3)
    
  res <- simulx(model     = myModel,
                parameter = pop.param,
                treatment = list(time=0, amount=100),
                group     = list(size=N, level='individual'),
                output    = list(name='C', time=seq(0,24,by=0.1)))
  # res$C is a data.frame with 2000x241=482000 rows and 3 columns
  res$C[1:10,]
  # we can display the empirical percentiles of C using the default 
  # settings (i.e. percentiles of order 10\%, 20\%, ... 90\%)
  p1   <- prctilemlx(res$C)
  print(p1)
  # The 3 quartiles (i.e. percentiles of order 25\%, 50\% and 75\%) are displayed by 
  # selecting a 50\% interval splitted into 2 subintervals
  p2  <- prctilemlx(res$C, band=list(number=2, level=50))
  # A one 90\% interval can be displayed using only one interval
  p3   <- prctilemlx(res$C, band=list(number=1, level=90))
  # or 75 subintervals in order to better represent the continuous distribution 
  # of the data within this interval
  p4   <- prctilemlx(res$C, band=list(number=75, level=90))
  # The percentiles are not plotted by setting plot=FALSE
  p5   <- prctilemlx(res$C, band=list(number=4, level=80), plot=FALSE)
  print(names(p4))
  print(p4$proba)
  print(p4$color)
  print(p4$y[1:5,])
  print(p4$y[1:5,])
}
}

