% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/display.R
\name{sketch}
\alias{sketch}
\title{Show an ASCII art representation of a 2D image or matrix}
\usage{
sketch(x, invert = FALSE, width = getOption("width"), squash = 0.5)
}
\arguments{
\item{x}{An object that can be coerced to a numeric matrix or array. 3D
arrays with third dimension no greater than 4 will be taken as
multichannel 2D images, and their channels averaged before display.
Plain vectors and 1D arrays will be treated as single-row matrices.}

\item{invert}{By default the mapping uses heavier type for brighter areas.
If this option is \code{TRUE}, the sense of the scale will be reversed.}

\item{width}{The width of sketch to draw, in characters.}

\item{squash}{The factor by which to scale the row direction of the image.
Generally this should be markedly less than one, to preserve the aspect
ratio of the image, since most fixed-width font characters are taller than
they are wide.}
}
\value{
This function is called for the side-effect of printing an ASCII
  representation of its argument.
}
\description{
This function prints a rough, text-only representation of an image argument
to the R terminal, mapping image intensities to a 10-level pseudo-greyscale.
The image is first rescaled to fit into the terminal or other specified
width, and downsampled in the row direction to correct for nonsquare
character shapes.
}
\details{
The result is a compact representation of a matrix that can be used for
visualising kernel arrays, sparse matrices and other non-images.
}
\note{
If the terminal does not used a fixed-width font, the result is
  unlikely to be useful.
}
\examples{
sketch(shapeKernel(c(9,15), type="diamond"))
sketch(shapeKernel(c(9,15), type="diamond"), squash=1)
}
\seealso{
\code{\link{display}}
}
\author{
Jon Clayden <code@clayden.org>
}
