% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SingleTable-methods-exported.R
\name{SingleTable.modelFit}
\alias{SingleTable.modelFit}
\title{Exact posterior inference based on a single 2x2 table}
\usage{
SingleTable.modelFit(
  single_table_Obj,
  method = "exact",
  verbose = TRUE,
  control = list()
)
}
\arguments{
\item{single_table_Obj}{The object created by \code{SingleTable.create}.}

\item{method}{a character string specifying the method. Options are \code{exact}
and \code{sampling}. \code{exact} (default) is a method based on Monte Carlo sampling. \code{exact} is exact method.}

\item{verbose}{a logical value; if TRUE(default), the detailed summary messages are displayed, else the messages are omitted.}

\item{control}{a list can be specified to control the fitting process. Options are stated in details.}
}
\value{
An object of \code{singletable} class is returned including the following non-null values:
\item{measure}{the value of \code{measure} argument.}
\item{model}{the value of \code{model} argument.}
\item{data}{a numeric vector of input data with components: \code{y1}, \code{n1}, \code{y2}, \code{n2}.}
\item{parameter}{a numeric vector of the hyperparameters: \code{a1}, \code{b1}, \code{a2}, \code{b2}, and \code{rho}.}
\item{method}{the value of \code{method} argument.}
\item{sample}{a list of samples for the posterior and prior distributions.}
\item{density}{a list of the density of the posterior and prior distributions.}
}
\description{
This function conducts exact posterior inference based on the object created by \code{SingleTable.create}.
}
\details{
control list can be specified to control the fitting process:
\itemize{
\item \code{n_samples}:  number of posterior samples; Defualt is 5000.
\item \code{mcmc_initial}:  initial values for (p1, p2) in MCMC; Default is c(0.5, 0.5).
\item \code{upper_bound}:  upper bound for the measure. Default is 100.
\item \code{lower_bound}: lower bound for the measure. For RD, default is -1. For RR/OR, defualt is 0.
\item \code{num_grids}:  number of grids to calculate density; The defualt is 20498.
}
}
\examples{
## Assume we have a 2x2 table:{{40,56},{49,60}} and set prior parameters as a1=b1=a2=b2=rho=0.5.
 \donttest{
 library(mmeta)
 library(ggplot2)
 # ########################## If sampling method is used ############################
 ## Create object \code{single_table_obj_samling}
 single_table_obj_samling <- SingleTable.create(a1=0.5,b1=0.5,
 a2=0.5,b2=0.5,rho=0.5, y1=40, n1=96, y2=49, n2=109,model="Sarmanov",measure="OR")
 ## model fit
 single_table_obj_samling <- SingleTable.modelFit(single_table_obj_samling,
 method = 'sampling')
 ## Control list option examples
 ## set number of posterior samples as 3000 (default is 5000)
 single_table_obj_samling <- SingleTable.modelFit(single_table_obj_samling,
 method = 'sampling', control = list(n_sample = 3000))
 ## set initial values for MCMC is c(0.2, 0,4) (default is c(0.5,0.5))
 single_table_obj_samling <- SingleTable.modelFit(single_table_obj_samling,
 method = 'sampling', control = list(mcmc_initial = c(0.2,0.4)))
 ## set upper bound for the measure is 20( default is 100)
 single_table_obj_samling <- SingleTable.modelFit(single_table_obj_samling,
 method = 'sampling', control = list(upper_bound = 20))
 # ########################### If exact method is used ##############################
 ## Create object \code{single_table_obj_exact}
 single_table_obj_exact <- SingleTable.create(a1=0.5, b1=0.5, a2=0.5, b2=0.5,
 rho=0.5, y1=40, n1=96, y2=49, n2=109, model="Sarmanov",measure="OR")
 ## model fit
 single_table_obj_exact <- SingleTable.modelFit(single_table_obj_exact, method = 'exact')
 ## The options of \code{control} list specifying the fitting process are similar
 ## to the codes shown above.
 }
}
\seealso{
\code{SingleTable.summary}, \code{SingleTable.plot}.
}
