% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mmetrics.R
\name{add}
\alias{add}
\alias{gsummarize}
\alias{gsummarise}
\alias{gmutate}
\title{Aggregate metrics}
\usage{
add(df, ..., metrics = ad_metrics, summarize = TRUE)

gsummarize(df, ..., metrics)

gsummarise(df, ..., metrics)

gmutate(df, ..., metrics)
}
\arguments{
\item{df}{Data frame.}

\item{...}{Variables to group by.}

\item{metrics}{Metrics defined by \code{\link[mmetrics:define]{mmetrics::define()}}.}

\item{summarize}{Summarization flag. If it is \code{TRUE}, \code{add()} works as \code{gsummarize()}.
Otherwise, \code{add()} works as \code{gmutate()}.}
}
\value{
Data frame with calculated metrics
}
\description{
\code{add()} is wrapper function of \code{gmutate()} and \code{gsummarize()}.
\code{gmutate()} adds aggregated metrics as variables to the given data frame.
\code{gsummarize()} aggregates metrics from the given data frame.
\code{gsummarize()} and \code{gsummarise()} are synonyms.
}
\examples{
# Prepare data frame
df <- data.frame(
  gender = rep(c("M", "F"), 5),
  age = (1:10)*10,
  cost = (51:60),
  impression = (101:110),
  click = (0:9)*3
)

# Define metrics
metrics <- mmetrics::define(
  cost = sum(cost),
  ctr  = sum(click)/sum(impression)
)

# Evaluate
mmetrics::add(df, gender, metrics = metrics)

}
