% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replext_helpers.R
\name{appendInputParams}
\alias{appendInputParams}
\title{Append Input Parameters to Simulation Results}
\usage{
appendInputParams(df, input)
}
\arguments{
\item{df}{A data frame containing the simulation results.}

\item{input}{A list containing the user input parameters from the Shiny application.}
}
\value{
A data frame combining the original simulation results with a row-wise
repetition of the input parameters for each simulation run.
}
\description{
This internal helper function appends the user-specified input parameters to
each row of the simulation results data frame. This function is used to provide
a complete record of the parameters used for each simulation run.
}
\details{
The function first generates a unique identifier for each simulation
run. It then constructs a data frame of the input parameters based on the
selected simulation type (either 'replext_t1_' or 'replext_t2_'). The input
parameters are repeated to match the number of rows in the results data frame
and then appended to it. This augmented data frame provides a comprehensive
view of the results and the parameters used to generate them.
}
\keyword{internal}
