#' mnis: Easy Downloading Capabilities for the Member Name Information Service
#'
#' An API package for the Members' Name Information Service operated by the UK parliament. The package is intended to simplify pulling data from an API for users unfamiliar with APIs. Documentation for the API itself can be found here: http://data.parliament.uk/membersdataplatform/default.aspx.
#'
#' Note that on Unix-like systems there may be a warning message stating 'JSON string contains (illegal) UTF8 byte-order-mark!'. This does not appear to have any impact on the data itself, but is due to the encoding used by the API.
#'
#'
#' @section mnis functions:
#'
#' \code{\link{mnis_Additional}}
#'
#' \code{\link{mnis_Base}}
#'
#' \code{\link{mnis_ConstituencyResults}}
#'
#' \code{\link{mnis_Department}}
#'
#' \code{\link{mnis_Extra}}
#'
#' \code{\link{mnis_FullBiog}}
#'
#' \code{\link{mnis_GeneralElectionResults}}
#'
#' \code{\link{mnis_LordsType}}
#'
#' \code{\link{mnis_MemberDate}}
#'
#' \code{\link{mnis_PartyState}}
#'
#' \code{\link{mnis_Reference}}
#'
#' @docType package
#' @name mnis
#' @import utils
#' @import httr
#' @import jsonlite
#' @import plyr
NULL
