% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mnis_Reference.R
\name{mnis_Reference}
\alias{mnis_Reference}
\alias{ref_AddressTypes}
\alias{ref_AnsweringBodies}
\alias{ref_AreaTypes}
\alias{ref_Areas}
\alias{ref_BiographyCategories}
\alias{ref_Cabinets}
\alias{ref_CommitteeTypes}
\alias{ref_Committees}
\alias{ref_Constituencies}
\alias{ref_ConstituencyAreas}
\alias{ref_ConstituencyTypes}
\alias{ref_Countries}
\alias{ref_Departments}
\alias{ref_DisqualificationTypes}
\alias{ref_ElectionTypes}
\alias{ref_Elections}
\alias{ref_EndReasons}
\alias{ref_ExperienceTypes}
\alias{ref_GovernmentPostDepartments}
\alias{ref_GovernmentPosts}
\alias{ref_GovernmentRanks}
\alias{ref_HonourLists}
\alias{ref_HonouraryPrefixes}
\alias{ref_Honours}
\alias{ref_InterestCategories}
\alias{ref_LordsMembershipTypes}
\alias{ref_LordsRanks}
\alias{ref_OppositionPostDepartments}
\alias{ref_OppositionPosts}
\alias{ref_OppositionRanks}
\alias{ref_OtherParliaments}
\alias{ref_ParliamentTypes}
\alias{ref_ParliamentaryPosts}
\alias{ref_ParliamentaryRanks}
\alias{ref_Parties}
\alias{ref_PartySubTypes}
\alias{ref_PhotoOutputs}
\alias{ref_Statuses}
\alias{ref_Titles}
\title{mnis_Reference}
\usage{
mnis_Reference()

ref_AddressTypes()

ref_AnsweringBodies()

ref_Areas()

ref_AreaTypes()

ref_BiographyCategories()

ref_Cabinets()

ref_Committees()

ref_CommitteeTypes()

ref_Constituencies()

ref_ConstituencyAreas()

ref_ConstituencyTypes()

ref_Countries()

ref_Departments()

ref_DisqualificationTypes()

ref_Elections()

ref_ElectionTypes()

ref_EndReasons()

ref_ExperienceTypes()

ref_GovernmentPostDepartments()

ref_GovernmentPosts()

ref_GovernmentRanks()

ref_HonouraryPrefixes()

ref_HonourLists()

ref_Honours()

ref_InterestCategories()

ref_LordsMembershipTypes()

ref_LordsRanks()

ref_OppositionPostDepartments()

ref_OppositionPosts()

ref_OppositionRanks()

ref_OtherParliaments()

ref_ParliamentaryPosts()

ref_ParliamentaryRanks()

ref_ParliamentTypes()

ref_Parties()

ref_PartySubTypes()

ref_PhotoOutputs()

ref_Statuses()

ref_Titles()
}
\description{
A series of functions to return reference data. This data is useful for providing parameters for other function calls. The functions do not accept any arguments.
}
\examples{
\dontrun{
ref_AddressTypes()
# The types of addresses available in member's contact details.
# Includes websites and social media, as well as physical addresses.

ref_AnsweringBodies()
# The bodies that members' can address questions to.

ref_Areas()
# Geographic areas.

ref_AreaTypes()
# Identifiers for grouping areas (e.g. borough constituencies).

ref_BiographyCategories()
# Member biography categories.

ref_Cabinets()
# Connections that a member has to the cabinet or shadow cabinet.

ref_Committees()
# Identifier for parliamentary committees.

ref_CommitteeTypes()
# Types of parliamentary committees.

ref_Constituencies()
# All constituencies.

ref_ConstituencyAreas()
# The links between constituencies and constituency areas.

ref_ConstituencyTypes()
# Constituency categories.

ref_Countries()
# List of countries that could be listed as members' birthplace.

ref_Departments()
# Government and opposition departments.

ref_DisqualificationTypes()
# Types of ways members can be disqualified from sitting in the House.

ref_Elections()
# Codes of general and by-elections.

ref_ElectionTypes()
# Election categories.

ref_EndReasons()
# Reasons a member may leave the House of Lords or the House of Commons.

ref_ExperienceTypes()
# Types of non-parliamentary experience members can list.

ref_GovernmentPostDepartments()
# All deparments that can contain government posts.

ref_GovernmentPosts()
# All government posts.

ref_GovernmentRanks()
# All government post ranks.

ref_HonouraryPrefixes()
# The types of honourary prefixes for members.

ref_HonourLists()
# The types of honour lists that a member may be honoured in.

ref_Honours()
# The different honours available to members.

ref_InterestCategories()
# The categories available for reporting financial interests.

ref_LordsMembershipTypes()
# Different types of membership of the House of Lords.

ref_LordsRanks()
# Ranks that peers may hold.

ref_OppositionPostDepartments()
# The link between opposition posts and the government department they shadow.

ref_OppositionPosts()
# Opposition posts.

ref_OppositionRanks()
# How opposition posts are ranked.

ref_OtherParliaments()
# Other parliaments that a member may have sat in.

ref_ParliamentaryPosts()
# The different parliamentary posts available.

ref_ParliamentaryRanks()
# How those parliamentary posts are ranked.

ref_ParliamentTypes()
# Types of parliaments that parliamentary data may link to.

ref_Parties()
# All parties that members can be affiliated with.

ref_PartySubTypes()
# Sub-types of parties.

ref_PhotoOutputs()
# Outputs that a photo of a member may be linked to.

ref_Statuses()
# A member's possible current status in the House.

ref_titles()
# Salutory titles.

mnis_Reference()
# Returns a list of all possible reference functions.
}

}
\keyword{mnis}

