% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reading_speed.R
\name{readingSpeed}
\alias{readingSpeed}
\title{Reading speed calculation corrected for the number of errors}
\usage{
readingSpeed(data, reading_time, errors)
}
\arguments{
\item{data}{The name of your dataframe}

\item{reading_time}{The variable that contains the reading time for each sentence}

\item{errors}{The variable that contains the number of errors for each sentence}
}
\value{
The function returns the original dataframe with an added variable called "reading_speed" that contains reading speed (in words/min) for each sentence tested.
}
\description{
This function calculates reading speed (in words per minute) for each sentence tested.
This calculation takes into account the number of misread words and gives a more precise reading speed measurement than \code{\link{readingSpeed_nonCorrected}}.
}
\section{Notes}{

For general purposes, this method of reading speed calculation should be used preferentially over the less precise \code{\link{readingSpeed_nonCorrected}}.
}

\examples{
# inspect the strucutre of the dataframe
head(data_low_vision, 10)

# run the reading speed calculation
data_low_vision_new <- readingSpeed(data_low_vision, rt, err)

# inspect the structure of the newly created dataframe
head(data_low_vision_new, 10)

}
\seealso{
\code{\link{readingSpeed_nonCorrected}} for reading speed non corrected for errors
}
