% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute.acc.R
\name{compute.acc}
\alias{compute.acc}
\title{Predictive accuracy estimates across trees for logistic regression model}
\usage{
compute.acc(response, predictions, prob_cutoff = 0.5)
}
\arguments{
\item{response}{A vector of binary outcome.}

\item{predictions}{A matrix of predicted probabilities (logit model) for 
out-of-bag observations for each tree.}

\item{prob_cutoff}{The threshold for predicting 1's & 0's.}
}
\value{
Predictive accuracy estimate ranging between 0 and 1.
}
\description{
Compute predictive accuracy of response variable with binary outcome. 
The function takes observed and predicted binary responses as input and
computes proportion of observations classified in same group.
}
\examples{
response <- as.data.frame( c(rep(0, 10000), rep(1, 10000)))
predictions <-
  matrix(nrow = 20000, ncol = 3,
         data = c(rep(.1, 15000), rep(.8, 5000), rep(.1, 15000),
                  rep(.8, 5000), rep(.1, 15000), rep(.8, 5000)))
compute.acc(response, predictions, prob_cutoff = .5)
}
