% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_slopes.R
\name{estimate_slopes}
\alias{estimate_slopes}
\title{Estimate Marginal Effects}
\usage{
estimate_slopes(model, trend = NULL, levels = NULL, ci = 0.95, ...)
}
\arguments{
\item{model}{A statistical model.}

\item{trend}{A character vector indicating the name of the numeric variable
for which to compute the slopes.}

\item{levels}{A character vector indicating the variables over which the
slope will be computed. If NULL (default), it will select all the remaining
predictors.}

\item{ci}{Uncertainty Interval (CI) level. Default to 95\% (\code{0.95}).}

\item{...}{Other arguments passed for instance to \code{\link{visualisation_matrix}}.}
}
\value{
A data.frame.
}
\description{
Estimate the slopes (i.e., the coefficient) of a predictor over different factor levels. See also other
related functions such as \code{\link{estimate_contrasts}} and \code{\link{estimate_means}}.
}
\examples{
model <- lm(Sepal.Width ~ Species * Petal.Length, data = iris)
slopes <- estimate_slopes(model, trend = "Petal.Length")
slopes
effectsize::standardize(slopes)
\dontrun{
if (require("rstanarm")) {
  model <- stan_glm(Sepal.Width ~ Species * Petal.Length, data = iris, refresh = 0)
  estimate_slopes(model)
}
}

}
