% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variable_binning.R
\name{simple_bin}
\alias{simple_bin}
\title{Discretize variables in your training and test datasets}
\usage{
simple_bin(train, test = NULL, exclude_vars = NULL, include_vars = NULL,
  bins, type = "height", na_include = TRUE)
}
\arguments{
\item{train}{training set}

\item{test}{test set}

\item{exclude_vars}{variables to exclude (e.g. the target, or the row ID)}

\item{include_vars}{if you only want certain variables binned, you may specify them
directly instead of excluding all other variables}

\item{bins}{single number specifying the number of bins to create on each variable,
or a named list specifying cut-points for each variable}

\item{type}{if bins is given as a number, then this determines whether to create
bins with equal number of observations ("height") or of equal width
("width")}

\item{na_include}{logical. Give missing values their own bin?}
}
\value{
if test is not NULL, a list containing two tbl_df objects, with appropriate
    columns replaced by their binned values and all other columns unchanged
    if test is NULL, returns the training set portion of the list
}
\description{
Function to apply simple equal-width or equal-height binning to columns of a
training dataset, and then optionally bin the columns of a test set into bins
with the appropriate cutpoints
}
\details{
This function was built as a convenience, to automate the process of binning
continuous variables into disrete levels, and also to provide a simple,
interpretible, unambiguous method of dealing with missing values in data
science problems.
}
\seealso{
\code{\link{vector_bin}}, \code{\link{get_vector_cutpoints}}

Other discretization: \code{\link{binned_data_cutpoints}},
  \code{\link{get_vector_cutpoints}},
  \code{\link{vector_bin}}
}

