% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formulas.R
\name{formulas}
\alias{formulae}
\alias{formulas}
\title{Create a list of formulas}
\usage{
formulas(.response, ...)

formulae(.response, ...)
}
\arguments{
\item{.response}{A one-sided formula used as the left-hand side of
all resulting formulas.}

\item{...}{List of formulas whose right-hand sides will be merged
to \code{.response}.}
}
\description{
\code{formulas()} creates a list of two-sided formulas by merging a
unique left-hand side to a list of right-hand sides.
}
\examples{
# Provide named arguments to create a named list of formulas:
models <- formulas(~lhs,
  additive = ~var1 + var2,
  interaction = ~var1 * var2
)
models$additive

# The formulas are created sequentially, so that you can refer to
# previously created formulas:
formulas(~lhs,
  linear = ~var1 + var2,
  hierarchical = add_predictors(linear, ~(1 | group))
)
}

