% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasummary_correlation.R
\name{datasummary_correlation}
\alias{datasummary_correlation}
\title{Generate a correlation table for all numeric variables in your dataset.}
\usage{
datasummary_correlation(
  data,
  output = "default",
  fmt = "\%.2f",
  title = NULL,
  notes = NULL
)
}
\arguments{
\item{data}{A data.frame (or tibble)}

\item{output}{filename or object type (string)
\itemize{
  \item Supported filename extensions: .html, .tex, .md, .txt, .png, .jpg.
  \item Supported object types: "default", "html", "markdown", "latex", "data.frame", "gt", "kableExtra", "huxtable", "flextable".
  \item When a file name is supplied to the `output` argument, the table is written immediately to file. If you want to customize your table by post-processing it with functions provided by the `gt` or `kableExtra` packages, you need to choose a different output format (e.g., "gt", "latex", "html", "markdown"), and you need to save the table after post-processing using the `gt::gtsave`, `kableExtra::save_kable`, or `cat` functions.
}}

\item{fmt}{string which specifies how numeric values will be rounded. This
string is passed to the `sprintf` function. '\%.3f' will keep 3 digits after
the decimal point with trailing zero. '\%.5f' will keep 5 digits. '\%.3e' will
use exponential notation. See `?sprintf` for more options.}

\item{title}{string}

\item{notes}{list or vector of notes to append to the bottom of the table.}
}
\description{
Generate a correlation table for all numeric variables in your dataset.
}
