% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core-to_gluon_list_dataset.R
\name{to_gluon_list_dataset}
\alias{to_gluon_list_dataset}
\title{Convert a data frame to a GluonTS ListDataset}
\usage{
to_gluon_list_dataset(data, date_var, value_var, id_var = NULL, freq = "D")
}
\arguments{
\item{data}{A data.frame}

\item{date_var}{The date column (Timestamps)}

\item{value_var}{The value column (Target)}

\item{id_var}{The Time Series ID column for tracking time series in GluonTS}

\item{freq}{the Pandas Timestamp Frequency.}
}
\description{
A ListDataset is the format required by \code{GluonTS}. This function
simplifies creating a \code{GluonTS} ListDataset.
}
\examples{
\donttest{
library(timetk)

m4_daily \%>\%
    to_gluon_list_dataset(
        date_var  = date,
        value_var = value,
        id_var    = id,
        freq      = "D"
    )
}


}
