% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parsnip-prophet_reg.R
\name{prophet_fit_impl}
\alias{prophet_fit_impl}
\title{Low-Level PROPHET function for translating modeltime to PROPHET}
\usage{
prophet_fit_impl(
  x,
  y,
  growth = "linear",
  n.changepoints = 25,
  changepoint.range = 0.8,
  yearly.seasonality = "auto",
  weekly.seasonality = "auto",
  daily.seasonality = "auto",
  seasonality.mode = "additive",
  changepoint.prior.scale = 0.05,
  seasonality.prior.scale = 10,
  holidays.prior.scale = 10,
  logistic_cap = NULL,
  logistic_floor = NULL,
  ...
)
}
\arguments{
\item{x}{A dataframe of xreg (exogenous regressors)}

\item{y}{A numeric vector of values to fit}

\item{growth}{String 'linear' or 'logistic' to specify a linear or logistic
trend.}

\item{n.changepoints}{Number of potential changepoints to include. Not used
if input `changepoints` is supplied. If `changepoints` is not supplied,
then n.changepoints potential changepoints are selected uniformly from the
first `changepoint.range` proportion of df$ds.}

\item{changepoint.range}{Proportion of history in which trend changepoints
will be estimated. Defaults to 0.8 for the first 80%. Not used if
`changepoints` is specified.}

\item{yearly.seasonality}{Fit yearly seasonality. Can be 'auto', TRUE,
FALSE, or a number of Fourier terms to generate.}

\item{weekly.seasonality}{Fit weekly seasonality. Can be 'auto', TRUE,
FALSE, or a number of Fourier terms to generate.}

\item{daily.seasonality}{Fit daily seasonality. Can be 'auto', TRUE,
FALSE, or a number of Fourier terms to generate.}

\item{seasonality.mode}{'additive' (default) or 'multiplicative'.}

\item{changepoint.prior.scale}{Parameter modulating the flexibility of the
automatic changepoint selection. Large values will allow many changepoints,
small values will allow few changepoints.}

\item{seasonality.prior.scale}{Parameter modulating the strength of the
seasonality model. Larger values allow the model to fit larger seasonal
fluctuations, smaller values dampen the seasonality. Can be specified for
individual seasonalities using add_seasonality.}

\item{holidays.prior.scale}{Parameter modulating the strength of the holiday
components model, unless overridden in the holidays input.}

\item{logistic_cap}{When growth is logistic, the upper-bound for "saturation".}

\item{logistic_floor}{When growth is logistic, the lower-bound for "saturation".}

\item{...}{Additional arguments passed to \code{prophet::prophet}}
}
\description{
Low-Level PROPHET function for translating modeltime to PROPHET
}
