% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parsnip-nnetar_reg.R
\name{nnetar_reg}
\alias{nnetar_reg}
\title{General Interface for NNETAR Regression Models}
\usage{
nnetar_reg(
  mode = "regression",
  seasonal_period = NULL,
  non_seasonal_ar = NULL,
  seasonal_ar = NULL,
  hidden_units = NULL,
  num_networks = NULL,
  penalty = NULL,
  epochs = NULL
)
}
\arguments{
\item{mode}{A single character string for the type of model.
The only possible value for this model is "regression".}

\item{seasonal_period}{A seasonal frequency. Uses "auto" by default.
A character phrase of "auto" or time-based phrase of "2 weeks"
can be used if a date or date-time variable is provided.
See Fit Details below.}

\item{non_seasonal_ar}{The order of the non-seasonal auto-regressive (AR) terms. Often denoted "p" in pdq-notation.}

\item{seasonal_ar}{The order of the seasonal auto-regressive (SAR) terms. Often denoted "P" in PDQ-notation.}

\item{hidden_units}{An integer for the number of units in the hidden model.}

\item{num_networks}{Number of networks to fit with different random starting weights.
These are then averaged when producing forecasts.}

\item{penalty}{A non-negative numeric value for the amount of weight
decay.}

\item{epochs}{An integer for the number of training iterations.}
}
\description{
\code{nnetar_reg()} is a way to generate a \emph{specification} of an NNETAR model
before fitting and allows the model to be created using
different packages. Currently the only package is \code{forecast}.
}
\details{
The data given to the function are not saved and are only used
to determine the \emph{mode} of the model. For \code{nnetar_reg()}, the
mode will always be "regression".

The model can be created using the \code{fit()} function using the
following \emph{engines}:
\itemize{
\item "nnetar" (default) - Connects to \code{\link[forecast:nnetar]{forecast::nnetar()}}
}

\strong{Main Arguments}

The main arguments (tuning parameters) for the model are the parameters in
\code{nnetar_reg()} function. These arguments are converted to their specific names at the
time that the model is fit.

Other options and argument can be
set using \code{set_engine()} (See Engine Details below).

If parameters need to be modified, \code{update()} can be used
in lieu of recreating the object from scratch.
}
\section{Engine Details}{


The standardized parameter names in \code{modeltime} can be mapped to their original
names in each engine:\tabular{ll}{
   modeltime \tab forecast::nnetar \cr
   seasonal_period \tab ts(frequency) \cr
   non_seasonal_ar \tab p (1) \cr
   seasonal_ar \tab P (1) \cr
   hidden_units \tab size (10) \cr
   num_networks \tab repeats (20) \cr
   epochs \tab maxit (100) \cr
   penalty \tab decay (0) \cr
}


Other options can be set using \code{set_engine()}.

\strong{nnetar}

The engine uses \code{\link[forecast:nnetar]{forecast::nnetar()}}.

Function Parameters:

\if{html}{\out{<div class="sourceCode">}}\preformatted{#> function (y, p, P = 1, size, repeats = 20, xreg = NULL, lambda = NULL, 
#>     model = NULL, subset = NULL, scale.inputs = TRUE, x = y, ...)
}\if{html}{\out{</div>}}

Parameter Notes:
\itemize{
\item \code{xreg} - This is supplied via the parsnip / modeltime \code{fit()} interface
(so don't provide this manually). See Fit Details (below).
\item \code{size} - Is set to 10 by default. This differs from the \code{forecast} implementation
\item \code{p} and \code{P} - Are set to 1 by default.
\item \code{maxit} and \code{decay} are \code{nnet::nnet} parameters that are exposed in the \code{nnetar_reg()} interface.
These are key tuning parameters.
}
}

\section{Fit Details}{


\strong{Date and Date-Time Variable}

It's a requirement to have a date or date-time variable as a predictor.
The \code{fit()} interface accepts date and date-time features and handles them internally.
\itemize{
\item \code{fit(y ~ date)}
}

\emph{Seasonal Period Specification}

The period can be non-seasonal (\verb{seasonal_period = 1 or "none"}) or
yearly seasonal (e.g. For monthly time stamps, \code{seasonal_period = 12}, \code{seasonal_period = "12 months"}, or \code{seasonal_period = "yearly"}).
There are 3 ways to specify:
\enumerate{
\item \code{seasonal_period = "auto"}: A seasonal period is selected based on the periodicity of the data (e.g. 12 if monthly)
\item \code{seasonal_period = 12}: A numeric frequency. For example, 12 is common for monthly data
\item \code{seasonal_period = "1 year"}: A time-based phrase. For example, "1 year" would convert to 12 for monthly data.
}

\strong{Univariate (No xregs, Exogenous Regressors):}

For univariate analysis, you must include a date or date-time feature. Simply use:
\itemize{
\item Formula Interface (recommended): \code{fit(y ~ date)} will ignore xreg's.
\item XY Interface: \code{fit_xy(x = data[,"date"], y = data$y)} will ignore xreg's.
}

\strong{Multivariate (xregs, Exogenous Regressors)}

The \code{xreg} parameter is populated using the \code{fit()} or \code{fit_xy()} function:
\itemize{
\item Only \code{factor}, \verb{ordered factor}, and \code{numeric} data will be used as xregs.
\item Date and Date-time variables are not used as xregs
\item \code{character} data should be converted to factor.
}

\emph{Xreg Example:} Suppose you have 3 features:
\enumerate{
\item \code{y} (target)
\item \code{date} (time stamp),
\item \code{month.lbl} (labeled month as a ordered factor).
}

The \code{month.lbl} is an exogenous regressor that can be passed to the \code{nnetar_reg()} using
\code{fit()}:
\itemize{
\item \code{fit(y ~ date + month.lbl)} will pass \code{month.lbl} on as an exogenous regressor.
\item \code{fit_xy(data[,c("date", "month.lbl")], y = data$y)} will pass x, where x is a data frame containing \code{month.lbl}
and the \code{date} feature. Only \code{month.lbl} will be used as an exogenous regressor.
}

Note that date or date-time class values are excluded from \code{xreg}.
}

\examples{
library(dplyr)
library(parsnip)
library(rsample)
library(timetk)
library(modeltime)

# Data
m750 <- m4_monthly \%>\% filter(id == "M750")
m750

# Split Data 80/20
splits <- initial_time_split(m750, prop = 0.8)

# ---- NNETAR ----

# Model Spec
model_spec <- nnetar_reg() \%>\%
    set_engine("nnetar")

# Fit Spec
set.seed(123)
model_fit <- model_spec \%>\%
    fit(log(value) ~ date, data = training(splits))
model_fit



}
\seealso{
\code{\link[=fit.model_spec]{fit.model_spec()}}, \code{\link[=set_engine]{set_engine()}}
}
