% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dials-prophet_params.R
\name{prophet_params}
\alias{prophet_params}
\alias{growth}
\alias{changepoint_num}
\alias{changepoint_range}
\alias{seasonality_yearly}
\alias{seasonality_weekly}
\alias{seasonality_daily}
\alias{prior_scale_changepoints}
\alias{prior_scale_seasonality}
\alias{prior_scale_holidays}
\title{Tuning Parameters for Prophet Models}
\usage{
growth(values = c("linear", "logistic"))

changepoint_num(range = c(0L, 50L), trans = NULL)

changepoint_range(range = c(0.6, 0.9), trans = NULL)

seasonality_yearly(values = c(TRUE, FALSE))

seasonality_weekly(values = c(TRUE, FALSE))

seasonality_daily(values = c(TRUE, FALSE))

prior_scale_changepoints(range = c(-3, 2), trans = log10_trans())

prior_scale_seasonality(range = c(-3, 2), trans = log10_trans())

prior_scale_holidays(range = c(-3, 2), trans = log10_trans())
}
\arguments{
\item{values}{A character string of possible values.}

\item{range}{A two-element vector holding the \emph{defaults} for the smallest and
largest possible values, respectively. If a transformation is specified,
these values should be in the \emph{transformed units}.}

\item{trans}{A \code{trans} object from the \code{scales} package, such as
\code{scales::transform_log10()} or \code{scales::transform_reciprocal()}. If not provided,
the default is used which matches the units used in \code{range}. If no
transformation, \code{NULL}.}
}
\description{
Tuning Parameters for Prophet Models
}
\details{
The main parameters for Prophet models are:
\itemize{
\item \code{growth}: The form of the trend: "linear", or "logistic".
\item \code{changepoint_num}: The maximum number of trend changepoints allowed when modeling the trend
\item \code{changepoint_range}: The range affects how close the changepoints can go to the end of the time series.
The larger the value, the more flexible the trend.
\item Yearly, Weekly, and Daily Seasonality:
\itemize{
\item \emph{Yearly}: \code{seasonality_yearly} - Useful when seasonal patterns appear year-over-year
\item \emph{Weekly}: \code{seasonality_weekly} - Useful when seasonal patterns appear week-over-week (e.g. daily data)
\item \emph{Daily}: \code{seasonality_daily} - Useful when seasonal patterns appear day-over-day (e.g. hourly data)
}
\item \code{season}:
\itemize{
\item The form of the seasonal term: "additive" or "multiplicative".
\item See \code{\link[=season]{season()}}.
}
\item "Prior Scale": Controls flexibility of
\itemize{
\item \emph{Changepoints:} \code{prior_scale_changepoints}
\item \emph{Seasonality:} \code{prior_scale_seasonality}
\item \emph{Holidays:} \code{prior_scale_holidays}
\item The \code{log10_trans()} converts priors to a scale from 0.001 to 100,
which effectively weights lower values more heavily than larger values.
}
}
}
\examples{

growth()

changepoint_num()

season()

prior_scale_changepoints()

}
