% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ivreg_marg.R
\name{marg.ivreg}
\alias{marg.ivreg}
\title{Predicted Margins for `ivreg` objects from the \code{AER} package}
\usage{
\method{marg}{ivreg}(mod, var_interest, data, weights = NULL, ...)
}
\arguments{
\item{mod}{model object, currently only support those of class \code{\link[stats]{glm}}
or \code{\link[AER]{ivreg}}}

\item{var_interest}{name of the variable of interest, must correspond to a
covariate in the model}

\item{data}{data.frame that margins should run over, defaults changes based
on class-specific method}

\item{weights}{numeric, vector of weights used to generate predicted levels,
defaults changes based on class-specific method. Must be equal to the number
of rows in \code{data}.}

\item{...}{additional parameters passed to \code{?marg}.}
}
\description{
Obtains predicted margins and standard errors
of those predictions from a fitted \code{ivreg} model object.
}
\examples{
# From ?AER::ivreg

# data
data("CigarettesSW", package = "AER")
CigarettesSW$rprice <- with(CigarettesSW, price/cpi)
CigarettesSW$rincome <- with(CigarettesSW, income/population/cpi)
CigarettesSW$tdiff <- with(CigarettesSW, (taxs - tax)/cpi)

# model
fm <- AER::ivreg(log(packs) ~ log(rprice) + log(rincome) |
                   log(rincome) + tdiff + I(tax/cpi),
                 data = CigarettesSW, subset = year == "1995")

# Get margins for different levels of price/cpi
rprice_levs <- round(quantile(CigarettesSW$rprice))

marg(fm, data = subset(CigarettesSW, year == "1995"),
     var_interest = 'rprice', at_var_interest = rprice_levs)

}
