% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotStationary.R
\name{plotStationary}
\alias{plotStationary}
\title{Plot stationary state probabilities}
\usage{
plotStationary(
  model,
  covs = NULL,
  col = NULL,
  plotCI = FALSE,
  alpha = 0.95,
  ...
)
}
\arguments{
\item{model}{\code{\link{momentuHMM}}, \code{\link{momentuHierHMM}}, \code{\link{miHMM}}, or \code{\link{miSum}} object}

\item{covs}{Optional data frame consisting of a single row indicating the covariate values to be used in plots.
If none are specified, the means of any covariates appearing in the model are used (unless covariate is a factor, in which case the first factor in the data is used).}

\item{col}{Vector or colors for the states (one color per state).}

\item{plotCI}{Logical indicating whether to include confidence intervals in plots (default: FALSE)}

\item{alpha}{Significance level of the confidence intervals (if \code{plotCI=TRUE}). Default: 0.95 (i.e. 95\% CIs).}

\item{...}{Additional arguments passed to \code{graphics::plot}. These can currently include \code{cex.axis}, \code{cex.lab}, \code{cex.legend}, \code{cex.main}, \code{legend.pos}, and \code{lwd}. See \code{\link[graphics]{par}}. \code{legend.pos} can be a single keyword from the list ``bottomright'', ``bottom'', ``bottomleft'', ``left'', ``topleft'', ``top'', ``topright'', ``right'', and ``center''.}
}
\description{
Plot stationary state probabilities
}
\examples{
# m is a momentuHMM object (as returned by fitHMM), automatically loaded with the package
m <- example$m

plotStationary(m)

}
