% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/downsizing.R
\name{computeUpsizedGC}
\alias{computeUpsizedGC}
\title{computeUpsizedGC}
\usage{
computeUpsizedGC(richness.table, side = 2, keep.real = TRUE, plot = FALSE)
}
\arguments{
\item{richness.table}{: matrix with samples in rows and downsizings in the columns as produced by downsizedRichnessL2T}

\item{side}{: by default is 2 (downsizings in the columns)}

\item{keep.real}{: by default is TRUE. Substitue the predicted values by the real values when is not NA}

\item{plot}{: default FALSE, plots the regressions}
}
\value{
matrix with the same dimensions as richness.table but with complete values.
}
\description{
This procedure takes a table of meaned downsized gene counts where at least one column
is donwsized at a common minimal level. It uses this information to fit distributions of correlations
between different downsized levels and "predict" values for the samples that have not the needed
sequencing depth. The fitting of the models is based on the n-1 to be closer to reality and avoid accumulating errors.
}
\details{
\code{computeUpsizedGC}
}
\author{
Edi Prifti & Emmanuelle Le Chatelier
}
\seealso{
\code{\link{downsizedRichnessL2T}} and \code{\link{downsizeGC.all}}
}

