% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache.R
\name{nso_cache_enable}
\alias{nso_cache_enable}
\title{Enable or configure caching}
\usage{
nso_cache_enable(dir = NULL, ttl = NULL)
}
\arguments{
\item{dir}{Directory for cache; defaults to user cache dir.}

\item{ttl}{Optional TTL in seconds for cached entries (applies to the
disk cache). If \code{NULL}, entries persist until cleared.}
}
\value{
Cache directory path (invisibly).
}
\description{
Caches table lists and codebooks on disk to speed up repeated calls.
Optionally set a time-to-live (TTL) for cache entries.
}
\examples{
# Enable caching in a temporary directory (for demo purposes)
cache_dir <- nso_cache_enable(dir = tempdir())

# Check status
nso_cache_status()

# Disable when done
nso_cache_disable()
}
