% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate.R
\name{generate_ndset}
\alias{generate_ndset}
\title{Generate a random set of mutually nondominated points}
\usage{
generate_ndset(n, d, method, seed = NULL, integer = FALSE)
}
\arguments{
\item{n}{\code{integer(1)}\cr Number of rows in the output.}

\item{d}{\code{integer(1)}\cr Number of columns in the output.}

\item{method}{\code{character(1)}\cr Method used to generate the random nondominated set.
See \strong{Details} below for more information.}

\item{seed}{\code{integer(1)}\cr Integer seed for random number generation. If \code{NULL},
a random seed is generated.}

\item{integer}{\code{logical(1)}\cr If \code{TRUE}, return integer-valued points.}
}
\value{
A numeric matrix of size \verb{n × d} containing nondominated points.
}
\description{
Generate a random set of \code{n} mutually nondominated points of dimension \code{d}
with the shape defined by \code{method}.

When \code{integer = FALSE} (the default), the points are generated within the
hypercube \eqn{(0,1)^d} and can be scaled to another range using
\code{\link[=normalise]{normalise()}}.  Otherwise, points are scaled to a non-negative integer range
that keeps the points mutually nondominated.
}
\details{
The available methods are:
\itemize{
\item \code{"simplex"}, \code{"linear"}, or \code{"L"}: Uniformly samples points on the
standard simplex.
\item \code{"concave-sphere"}, \code{"sphere"}, or \code{"C"}: Uniformly samples points
on the positive orthant of the unit hypersphere (concave for minimisation).
\item \code{"convex-sphere"} or \code{"X"}: Equivalent to \code{1 - generate_ndset(..., method="concave-sphere")},
which is convex for minimisation.
\item \code{"convex-simplex"}: Equivalent to \code{generate_ndset(..., method="concave-sphere")^4},
which is convex for minimisation. Such a set cannot be obtained by any
affine transformation of a subset of the hyper-sphere.
}

Method \code{"simplex"} uniformly samples points on the standard
\eqn{(d-1)}-simplex defined by \eqn{\{x \in R_+^d : \sum_i x_i = 1\}}. This
shape of nondominated set is also called \code{"linear"} in the literature
\citep{LacKlaFon2017box}.  Each point \eqn{\vec{z} \in (0,1)^d \subset
\mathbb{R}^d} is generated by sampling \eqn{d} independent and identically
distributed values \eqn{(x_1,x_2, \dots, x_d)} from the exponential
distribution, then dividing each value by the L1-norm of the vector,
\eqn{z_i = x_i / \sum_{i=1}^d x_i} \citep{RubMel1998simulation}.  Values
sampled from the exponential distribution are guaranteed to be positive.

Sampling from either the standard normal distribution
\citep{GueFonPaq2021hv} or the uniform distribution \citep{LacKlaFon2017box}
does not produce a uniform distribution when projected into the simplex.

Method \code{"concave-sphere"} uniformly samples points on the positive orthant
of the hyper-sphere, which is concave when all objectives are minimised.
Each point \eqn{\vec{z} \in (0,1)^d \subset \mathbb{R}^d} is generated by
sampling \eqn{d} independent and identically distributed values
\eqn{\vec{x}=(x_1,x_2, \dots, x_d)} from the standard normal distribution,
then dividing each value by the l2-norm of the vector, \eqn{z_i =
\frac{|x_i|}{\|\vec{x}\|_2}} \citep{Muller1959sphere}. The absolute value in
the numerator ensures that points are sampled on the positive orthant of the
hyper-sphere.  Sampling from the uniform distribution
\citep{LacKlaFon2017box} does not result in a uniform sampling when
projected onto the surface of the hyper-sphere.

Method \code{"convex-sphere"} is quivalent to \code{1 - generate_ndset(..., method="concave-sphere")}, which is convex for minimisation problems.  It
corresponds to translating points from the negative orthant of the
hyper-sphere to the positive orthant.

Method \code{"convex-simplex"} is equivalent to \code{generate_ndset(..., method="concave-sphere")^4}, which is convex for minimisation problems.
The corresponding surface is equivalent to a simplex curved towards the
origin.
}
\examples{
generate_ndset(5, 3, "simplex", seed = 42)
generate_ndset(5, 3, "simplex", seed = 42, integer = TRUE)
generate_ndset(4, 2, "sphere", seed = 123)
generate_ndset(3, 5, "convex-sphere", seed = 123)
generate_ndset(4, 4, "convex-simplex", seed = 123)

}
\references{
\insertAllCited{}
}
