% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mytable.R, R/mytable.df.R
\name{mytable}
\alias{mytable}
\alias{mytable.formula}
\alias{mytable.data.frame}
\title{Produce table for descriptive statistics}
\usage{
mytable(x, ...)

\method{mytable}{formula}(x, ...)

\method{mytable}{data.frame}(x, ...)
}
\arguments{
\item{x}{An R object, formula or data.frame}

\item{...}{arguments to be passed to \code{\link{mytable_sub}}}
}
\description{
Produce table for descriptive statistics by groups for several variables easily.
Depending on  the nature of these variables, different descriptive statistical
methods were used(t-test, ANOVA,Kruskal-Wallis, chisq, Fisher,...)
}
\section{Methods (by class)}{
\itemize{
\item \code{formula}: S3 method for formula

\item \code{data.frame}: S3 method for data.frame
}}

\examples{
mytable(acs)
mytable(~age+sex,data=acs)
mytable(Dx~age+sex+height+weight+TC+TG+HDLC,data=acs,method=3,digits=2)
mytable(am+cyl~.,data=mtcars)
out=mytable(sex~.,data=acs)
out
summary(out)
require(ztable)
ztable(out)
mytable(acs)
}
