% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distpower.R
\name{distPower}
\alias{distPower}
\alias{dpower}
\alias{ppower}
\alias{qpower}
\alias{rpower}
\title{Ditribution with a Power Law}
\usage{
dpower(x, pow, min = 0, max = 1)

ppower(x, pow, min = 0, max = 1)

qpower(p, pow, min = 0, max = 1)

rpower(n, pow, min = 0, max = 1)
}
\arguments{
\item{x}{vector of values where to evaluate the denisty or CDF.}

\item{pow}{degree of the power law.}

\item{min}{minimum value of the support of the distribution.}

\item{max}{maximum value of the support of the distribution.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1}, the length is taken to be the number required.}
}
\value{
\code{dpower} gives the density, \code{ppower} gives the cumulative
distribution function (CDF), \code{qpower} gives the quantile function
(i.e., the inverse of the CDF), and \code{rpower} generates random numbers.

The length of the result is determined by \code{n} for \code{rpower}, and is
the length of \code{x} or \code{p} for the other functions.
}
\description{
Density, distribution function, quantile function and random
generation for a continuous distribution with the density
\code{(pow+1)*(x-min)^pow/(max-min)^(pow+1)} for \code{x}
in the range \code{[min,max]} and \code{pow > -1}.
}
