% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.MFx.R
\name{plot.MFx}
\alias{plot.MFx}
\title{Plotting method for \code{MFx} objects}
\usage{
\method{plot}{MFx}(
  x,
  x_variable = "MFx",
  xlab = NULL,
  ylab = "Survival probability \\n median and 95 CI",
  main = NULL,
  log_scale = FALSE,
  ncol = 3,
  ...
)
}
\arguments{
\item{x}{An object of class \code{MFx}.}

\item{x_variable}{A character to define the variable for the \eqn{X}-axis,
either \code{"MFx"} or \code{"Time"}. The default is \code{"MFx"}.}

\item{xlab}{A label for the \eqn{X}-axis, by default \code{NULL} and depend on the
argument \code{x_variable}.}

\item{ylab}{A label for the \eqn{Y}-axis, by default \code{Survival probability median and 95 CI}.}

\item{main}{A main title for the plot.}

\item{log_scale}{If \code{TRUE}, the x-axis is log-scaled. Default is \code{FALSE}.}

\item{ncol}{An interger for the number of columns when several panels are plotted.}

\item{\dots}{Further arguments to be passed to generic methods.}
}
\value{
a plot of class \code{ggplot}
}
\description{
This is the generic \code{plot} S3 method for the
\code{MFx} class. It plots the survival probability as a function of
the multiplication factor applied or as a function of time.
}
\examples{

# (1) Load the data
data("propiconazole")

# (2) Create an object of class 'survData'
dataset <- survData(propiconazole)

\donttest{
# (3) Run the survFit function with model_type SD (or IT)
out_SD <- survFit(dataset, model_type = "SD")

# (4) data to predict
data_4prediction <- data.frame(time = 1:10, conc = c(0,0.5,3,3,0,0,0.5,3,1.5,0))

# (5) estimate MF for 30\% reduction of survival at time 4
MFx_SD_30.4 <- MFx(out_SD, data_predict = data_4prediction , X = 30, time_MFx = 4)

# (6) plot the object of class 'MFx'
plot(MFx_SD_30.4)

# (6bis) plot with log-scale of x-axis
plot(MFx_SD_30.4, log_scale = TRUE)

# (6ter) plot with "Time" as the x-axis
plot(MFx_SD_30.4, x_variable = "Time") 

# (7) plot when X = NULL and along a MFx_range from 5 to 10:
MFx_SD_range <- MFx(out_SD, data_predict = data_4prediction ,
                    X = NULL, time_MFx = 4, MFx_range = seq(5, 10, length.out = 50))
plot(MFx_SD_range)
plot(MFx_SD_range, x_variable = "Time", ncol = 10)
}

}
\keyword{plot}
