% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compareProportion.R
\name{compareProportion}
\alias{compareProportion}
\title{Compare proportions between 2 groups}
\usage{
compareProportion(formula, data = NULL, ...)
}
\arguments{
\item{formula}{a formula}

\item{data}{a data frame in which \code{x} is evaluated if \code{x} is a
formula.}

\item{\dots}{other arguments}
}
\value{
the difference in proportions between the second and first group
}
\description{
A function to facilitate 2 group permutation tests for a categorical outcome variable
}
\note{
This funciton has been deprecated. Use \code{\link{diffprop}} instead.
}
\examples{
if (require(mosaicData)) {
  data(HELPrct)
  # calculate the observed difference
  mean(homeless=="housed" ~ sex, data=HELPrct)
  obs <- diffprop(homeless=="housed" ~ sex, data=HELPrct); obs
  # calculate the permutation distribution
  nulldist <- do(100) * diffprop(homeless=="housed" ~ shuffle(sex), data=HELPrct)
  histogram(~ diffprop, groups=(diffprop>= obs), nulldist, 
    xlab="difference in proportions")
}
}
\keyword{iteration}
\keyword{stats}
