% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do.R
\name{set.rseed}
\alias{set.rseed}
\title{Set seed in parallel compatible way}
\usage{
set.rseed(seed)
}
\arguments{
\item{seed}{seed for the random number generator}
}
\description{
When the parallel package is used, setting the RNG seed for reproducibility
involves more than simply calling \code{\link{set.seed}}. \code{set.rseed} takes
care of the additional overhead.
}
\details{
If the \code{parallel} package is not on the search path, then \code{\link{set.seed}} is called.
If \code{parallel} is on the search path, then the RNG kind is set to \code{"L'Ecuyer-CMRG"},
the seed is set and \code{mc.reset.stream} is called.
}
\examples{
# These should give identical results, even if the `parallel' package is loaded.
set.rseed(123); do(3) * resample(1:10, 2)
set.rseed(123); do(3) * resample(1:10, 2)
}
