% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ashplots.R
\name{ashplot}
\alias{ashplot}
\alias{prepanel.default.ashplot}
\alias{panel.ashplot}
\title{Average Shifted Histograms}
\usage{
ashplot(x, data = data, ..., width = NULL, adjust = NULL,
  panel = panel.ashplot, prepanel = prepanel.default.ashplot)

prepanel.default.ashplot(x, darg, groups = NULL, subscripts = TRUE, ...)

panel.ashplot(x, darg = list(), plot.points = FALSE, ref = FALSE,
  groups = NULL, jitter.amount = 0.01 * diff(current.panel.limits()$ylim),
  type = "p", ..., identifier = "ash")
}
\arguments{
\item{x}{A formula or numeric vector.}

\item{data}{A data frame.}

\item{...}{Additional arguments passed to panel and prepanel functions or \code{data}, a
data frame in which to find the variables used for the plot.}

\item{width}{The histogram bin width.}

\item{adjust}{A numeric adjustment to \code{width}.  Primarily useful when \code{width} is
not specified.  Increasing \code{adjust} makes the plot smoother.}

\item{panel}{A panel function.}

\item{prepanel}{A prepanel function.}

\item{darg}{a list of arguments for the function computing the ASH.}

\item{groups}{as in other lattice plots}

\item{subscripts}{as in other lattice prepanel functions}

\item{plot.points}{One of \code{TRUE}, \code{FALSE}, \code{"jitter"}, or \code{"rug"}}

\item{ref}{a logical indicating whether a reference line should be displayed}

\item{jitter.amount}{when \code{plot.points="jitter"}, the value to use as the amount
argument to \code{\link[=jitter]{jitter()}}.}

\item{type}{type argument used to plot points, if requested.
This is not expected to be useful, it is available mostly to protect a \code{type} argument,
if specified, from affecting the display of the ASH.}

\item{identifier}{A character string that is prepended to the names of i
grobs that are created by this panel function.}
}
\description{
An ASH plot is the average over all histograms of a fixed bin width.
}
\examples{
ashplot( ~age | substance, groups = sex, data = HELPrct)
}
