% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mosumTest.R
\name{mosum.test}
\alias{mosum.test}
\title{MOSUM test}
\usage{
mosum.test(m)
}
\arguments{
\item{m}{a \code{mosum} object}
}
\value{
S3 \code{mosum.test} object, which contains the following fields:
   \item{m}{the input \code{mosum} object}
   \item{statistic}{the value of the MOSUM statistic}
   \item{p.value}{the p-value of the test}
   \item{estimate}{the changepoint estimation}
}
\description{
Computes the result of the MOSUM test for changes in the mean.
}
\examples{
x <- piecewiseStationary_timeSeries(lengths=rep(100,3), means=c(0,2,-1), sds=rep(1,3))
m <- mosum(x, G=40)
mTest <- mosum.test(m)
mTest$estimate
mTest$p.value
}
