% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/local_prune.R
\name{multiscale.localPrune}
\alias{multiscale.localPrune}
\title{Multiscale MOSUM algorithm with localised pruning}
\usage{
multiscale.localPrune(x, G = bandwidths.default(length(x)),
  threshold = c("critical.value", "custom")[1], alpha = 0.05,
  threshold.function = NULL, criterion = c("eta", "epsilon")[1],
  eta = 0.4, epsilon = 0.2, rule = c("pval", "jump")[1],
  penalty = c("log", "polynomial")[1], pen.exp = 1.01, do.confint = F,
  level = 0.05, N_reps = 1000, ...)
}
\arguments{
\item{x}{input data (\code{numeric} vector or object of class \code{ts})}

\item{G}{a vector of bandwidths, given as either integers or numbers between 
\code{0} and \code{0.5} describing the moving sum bandwidths relative to \code{length(x)}}

\item{threshold}{string indicating which threshold should be used to determine significance.
By default, it is chosen from the asymptotic distribution at the given significance level \code{alpha}.
Alternatively, it is possible to parse a user-defined function with \code{threshold.function}}

\item{alpha}{a numeric value for the significance level with
\code{0 <= alpha <= 1}. Use iff \code{threshold='critical.value'}}

\item{threshold.function}{function object of form \code{function(G_l, G_r, length(x), alpha)}, to compute a
threshold of significance for different bandwidths (G_l, G_r); use iff \code{threshold='custom'}}

\item{criterion}{how to decide whether an exceeding point is a change-point; to be parsed to \link[mosum]{mosum}}

\item{eta, epsilon}{see \link[mosum]{mosum}}

\item{rule}{string for the choice of sorting criterion in merging step. 
Possible values are: 
\itemize{
\item{\code{'pval'}}{lowest p-value}
\item{\code{'jump'}}{largest (rescaled) jump size}
}}

\item{penalty}{string indicating which kind of penalty term is used; possible values are:
\itemize{
\item{\code{'log'}}{use \code{penalty = log(length(x))^pen.exp}}
\item{\code{'polynomial'}}{use \code{penalty = length(x)^pen.exp}}
}}

\item{pen.exp}{exponent for penalty term (see \code{penalty});}

\item{do.confint}{flag indicating whether confidence intervals for change-points should be computed}

\item{level}{use iff \code{do.confint=TRUE}; a numeric value (\code{0 <= level <= 1}) with which
\code{100(1-level)\%} confidence interval is generated}

\item{N_reps}{use iff \code{do.confint=TRUE}; number of bootstrap replicates to be generated}

\item{...}{further arguments to be parsed to \link[mosum]{mosum} calls}
}
\value{
S3 \code{multiscale.cpts} object, which contains the following fields:
   \item{x}{input data}
   \item{cpts}{estimated change-points}
   \item{cpts.info}{data frame containing information about estimated change-points}
   \item{sc}{SC value of the estimated change-point set}
   \item{pooled.cpts}{set of change-point candidates that have been considered by the algorithm}
   \item{G}{input parameter}
   \item{threshold,alpha,threshold.function}{input parameters}
   \item{criterion,eta,epsilon}{input parameters}
   \item{rule,penalty,pen.exp}{input parameters}
   \item{do.confint}{input parameter}
   \item{ci}{object of class \code{cpts.ci} containing confidence intervals for change-points iff \code{do.confint=TRUE}}
}
\description{
Multiscale (asymmetric) MOSUM procedure with localised pruning using Schwarz criterion (SC).
}
\details{
See Algorithm 2 in the first referenced paper for a comprehensive
description of the procedure and further details.
}
\examples{
x <- testData(model='mix')
mlp <- multiscale.localPrune(x, G=c(8, 15, 30, 70), do.confint=TRUE)
print(mlp)
summary(mlp)
par(mfcol=c(2, 1), mar=c(2, 4, 2, 2))
plot.ts(x)
abline(v=mlp$cpts, col=2)
plot(mlp)
}
\references{
A. Meier, C. Kirch and H. Cho (2018+)
mosum: A Package for Moving Sums in Change Point Analysis. \emph{Unpublished manuscript}.

H. Cho and C. Kirch (2018+)
Multiple change-point detection via multiscale MOSUM procedure with localised pruning. \emph{Unpublished manuscript}.
}
