% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{cluster_spectrum}
\alias{cluster_spectrum}
\title{Get cluster assignments from spectrum using k-means++}
\usage{
cluster_spectrum(spectrum, num_clusts)
}
\arguments{
\item{spectrum}{A list containing \code{$vects};
the matrix of eigenvectors to pass to k-means++.}

\item{num_clusts}{The number of clusters to find.}
}
\value{
A length-nrow(spectrum$vects) vector of integers
from 1 to num_clusts, representing cluster assignments.
}
\description{
Get a vector of cluster assignments from a spectrum,
using k-means++ and \code{num_clusts} clusters.
}
\keyword{internal}
