% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cladeIdentity.R
\name{cladeIdentity}
\alias{cladeIdentity}
\title{Identify branches (including tips) descended from a node (internal function).}
\usage{
cladeIdentity(phy, nodeIDs, cladeMembersObj = NULL)
}
\arguments{
\item{phy}{An object of class "phylo" (see ape package).}

\item{nodeIDs}{Vector of node numbers (positive integers).}

\item{cladeMembersObj}{Matrix of clade membership}
}
\value{
matrix Matrix of unique presences for each node id
}
\description{
Internal function to get presence absence of descendent branches from a vector of node numbers. The descendents include the branch leading to the focal node (i.e. node defines the stem group no crown group
}
\details{
The function returns a matrix of unique presences given the selected node. If the selected nodes are nested then presences are only recorded for the least inclusive node.
}
\examples{
## Read in phylogeny and data from Thomas et al. (2009)
data(anolis.tree)
data(anolis.data)

cladeIdentityMatrix <- cladeIdentity(phy=anolis.tree, nodeIDs=170)
}
\author{
Gavin Thomas
}
