% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/movecomp.R
\name{movecomp}
\alias{movecomp}
\title{R function for comparing least-cost paths generated using different cost functions}
\usage{
movecomp(
  dtm = NULL,
  origin,
  destin,
  studyplot = NULL,
  barrier = NULL,
  choice,
  move = 16,
  field = 0,
  cogn.slp = FALSE,
  sl.crit = 10,
  W = 70,
  L = 0,
  N = 1,
  V = 1.2,
  z = 9,
  return.base = FALSE,
  leg.pos = "topright",
  cex.leg = 0.75,
  transp = 0.5,
  oneplot = TRUE,
  export = FALSE
)
}
\arguments{
\item{dtm}{Digital Terrain Model (RasterLayer class); if not provided, elevation data will be acquired online for the area enclosed by the 'studyplot' parameter (see \code{\link{movecost}}).}

\item{origin}{location(s) around which the boundary(ies) is calculated (SpatialPointsDataFrame class).}

\item{destin}{location(s) to which least-cost path(s) is calculated (SpatialPointsDataFrame class).}

\item{studyplot}{polygon (SpatialPolygonDataFrame class) representing the study area for which online elevation data are aquired (see \code{\link{movecost}}); NULL is default.}

\item{barrier}{area where the movement is inhibited (SpatialLineDataFrame or SpatialPolygonDataFrame class) (see \code{\link{movecost}}.}

\item{choice}{character vector indicating the cost functions to be compared (for details on each of the following, see \code{\link{movecost}}):\cr

\strong{-functions expressing cost as walking time-}\cr
\strong{t} (default) uses the on-path Tobler's hiking function;\cr
\strong{tofp} uses the off-path Tobler's hiking function;\cr
\strong{mp} uses the Marquez-Perez et al.'s modified Tobler's function;\cr
\strong{icmonp} uses the Irmischer-Clarke's hiking function (male, on-path);\cr
\strong{icmoffp} uses the Irmischer-Clarke's hiking function (male, off-path);\cr
\strong{icfonp} uses the Irmischer-Clarke's hiking function (female, on-path);\cr
\strong{icfoffp} uses the Irmischer-Clarke's hiking function (female, off-path);\cr
\strong{ug} uses the Uriarte Gonzalez's walking-time cost function;\cr
\strong{ma} uses the Marin Arroyo's walking-time cost function;\cr
\strong{alb} uses the Alberti's Tobler hiking function modified for pastoral foraging excursions;\cr
\strong{gkrs} uses the Garmy, Kaddouri, Rozenblat, and Schneider's hiking function;\cr
\strong{r} uses the Rees' hiking function;\cr
\strong{ks} uses the Kondo-Seino's hiking function;\cr

\strong{-functions for wheeled-vehicles-}\cr
\strong{wcs} uses the wheeled-vehicle critical slope cost function;\cr

\strong{-functions expressing abstract cost-}\cr
\strong{ree} uses the relative energetic expenditure cost function;\cr
\strong{b} uses the Bellavia's cost function;\cr
\strong{e} uses the Eastman's cost function;\cr

\strong{-functions expressing cost as metabolic energy expenditure-}\cr
\strong{p} uses the Pandolf et al.'s metabolic energy expenditure cost function;\cr
\strong{pcf} uses the Pandolf et al.'s cost function with correction factor for downhill movements;\cr
\strong{m} uses the Minetti et al.'s metabolic energy expenditure cost function;\cr
\strong{hrz} uses the Herzog's metabolic energy expenditure cost function;\cr
\strong{vl} uses the Van Leusen's metabolic energy expenditure cost function;\cr
\strong{ls} uses the Llobera-Sluckin's metabolic energy expenditure cost function;\cr
\strong{a} uses the Ardigo et al.'s metabolic energy expenditure cost function;\cr
\strong{h} uses the Hare's metabolic energy expenditure cost function (for all the mentioned cost functions, see \code{\link{movecost}});\cr}

\item{move}{number of directions in which cells are connected: 4 (rook's case), 8 (queen's case), 16 (knight and one-cell queen moves; default).}

\item{field}{value assigned to the cells coincidinng with the barrier (0 by default) (see \code{\link{movecost}}.}

\item{cogn.slp}{TRUE or FALSE (default) if the user wants or does not want the 'cognitive slope' to be used in place of the real slope (see \code{\link{movecost}}).}

\item{sl.crit}{critical slope (in percent), typically in the range 8-16 (10 by default) (used by the wheeled-vehicle cost function; see \code{\link{movecost}}).}

\item{W}{walker's body weight (in Kg; 70 by default; used by the Pandolf's and Van Leusen's cost function; see \code{\link{movecost}}).}

\item{L}{carried load weight (in Kg; 0 by default; used by the Pandolf's and Van Leusen's cost function; see \code{\link{movecost}}).}

\item{N}{coefficient representing ease of movement (1 by default) (see \code{\link{movecost}}).}

\item{V}{speed in m/s (1.2 by default) (used by the Pandolf et al.'s, Pandolf et al.s with correction factor, Van Leusen's, and Ardigo et al.'s cost function; if set to 0, it is internally worked out on the basis of Tobler on-path hiking function (see \code{\link{movecost}}).}

\item{z}{zoom level for the elevation data downloaded from online sources (from 0 to 15; 9 by default) (see \code{\link{movecost}} and \code{\link[elevatr]{get_elev_raster}}).}

\item{return.base}{TRUE or FALSE (default) if the user wants or does not want the least-cost paths back to the origin to be calculated and plotted (as dashed lines).}

\item{leg.pos}{set the position of the legend in the plotted cost allocation raster; 'topright' by default (other options: "bottomright", "bottom", "bottomleft", "left", "topleft", "top", "topright", "right", "center").}

\item{cex.leg}{set the size of the labels used in the legend displayed in the rendered plot (0.75 by default).}

\item{transp}{set the transparency of the hillshade raster that is plotted over the DTM (0.5 by default).}

\item{oneplot}{TRUE (default) or FALSE if the user wants or does not want the plots displayed in a single window.}

\item{export}{TRUE or FALSE (default) if the user wants or does not want the LCPs to be exported as a shapefile; the DTM is exported only if it was not provided by the user
and downloaded by the function from online sources.}
}
\value{
The function returns a list storing the following components \itemize{
 \item{dtm: }{Digital Terrain Model ('RasterLayer' class); returned only if aquired online}
 \item{LCPs: }{estimated least-cost paths ('SpatialLinesDataFrame' class)}
 \item{LCPs.back: }{estimated least-cost paths back to the origin ('SpatialLinesDataFrame' class)}
}
}
\description{
The function provides the facility to calculate LCPs using different cost functions and to plot them in the same visual output to allow
comparability. See, for instance, fig. 14.2 in Parcero-Oubina C. et al, Footprints and Cartwheels on a Pixel Road: On the Applicability of GIS for
the Modelling of Ancient (Roman) Routes (2019). In Verhagen P., Joyce J., Groenhuijzen M.R. (eds), Finding the
Limits of the Limes. Modelling Demography, Economy and Transport on the Edge of the Roman Empire, Springer,  291-311.\cr
Visit this \href{https://drive.google.com/file/d/1gLDrkZFh1b_glzCEqKdkPrer72JJ9Ffa/view?usp=sharing}{LINK} to access the package's vignette.\cr
}
\details{
Like 'movecost()', the function just requires an input DTM ('RasterLayer' class), and an origin and destination dataset  ('SpatialPointsDataFrame' class).
The cost functions to be used have to be entered into 'movecomp()' via a character vector fed via the 'choice' parameter (see the examples below).
If a DTM is not provided, 'movecomp()' downloads elevation data from online sources for the area enclosed by the polygon fed via
the 'studyplot' parameter (see \code{\link{movecost}} for more details). Under the hood, movecomp()' relies on 'movecost()' and implements the same cost functions:
see the help documentation of 'movecost()' for further information.\cr

'movecomp()' produces a plot representing the input DTM overlaid by an hillshade raster, whose transparency can be adjusted using
the 'transp' parameter. On the rendered plot, the LPCs ('SpatialLinesDataFrame' class) generated by the different input cost functions are given a different line type; a legend
indicates which line type corresponds to which cost function. LCPs back to the origin can be calculated (and plotted) setting the
parameter 'return.base' to TRUE.\cr

The function returns the LCPs and (if requested by the user) the LCPs back to the origin. If the DTM has been aquired online, it will be returned as well.
The LCPs (and the LCPs back to the origin) will store two attributes: the length of each path and an abbreviation corresponding to the cost function used to
generate each LCPs. This might prove handy if the user wants to compare the distribution of the length of groups of LCPs generate by different cost functions
(see the example in the 'Examples' section further down).
The mentioned data can be exported by setting the 'export' parameter to TRUE.\cr

The following example uses in-built datasets to compare the LCPs generated using two cost functions: the Tobler hiking function , the
wheeled vehicle cost function, and the Pantolf. et al's cost function with correction factor.
LCPs back to the origin location will be calculated as well. The origin and destination locations are close to Mt Etna (Sicily, Italy).
Note that elevation data are acquired online for the area enclosed by the polygon fed via the studyplot' parameter:\cr

result <- movecomp(origin=Etna_start_location, destin=Etna_end_location, choice=c("t", "wcs", "pcf"), studyplot = Etna_boundary, return.base=TRUE)\cr
}
\examples{
# load a sample Digital Terrain Model
data(volc)


# load the sample destination locations on the above DTM
data(destin.loc)


# compare the LCPs generated using the Tobler hiking function (for on-path walk)
# and the wheeled vehicle cost function

result <- movecomp(dtm=volc, origin=volc.loc, destin=destin.loc, choice=c("t", "wcs"), move=16)

#the distribution of the length of the LCPs can be easily compared using boxplots for instance:
boxplot(result$LCPs$length ~ result$LCPs$funct, xlab="cost function", ylab="length (meter)")


}
\seealso{
\code{\link{movecost}}
}
\keyword{movecomp}
