% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/granger.R
\name{get_granger_interactions}
\alias{get_granger_interactions}
\title{Get Granger Causality interactions}
\usage{
get_granger_interactions(
  sv,
  columns,
  cond_column = "",
  sig_level = 0.05,
  lag = 1,
  granger_fn = ms_grangertest2
)
}
\arguments{
\item{sv}{SplicedView object}

\item{columns}{vector of column names}

\item{cond_column}{name of conditioning column}

\item{sig_level}{significance level}

\item{lag}{in seconds (rounded to nearest frame)}

\item{granger_fn}{function to perform Granger test (defaults to ms_grangertest2)}
}
\value{
GrangerInteraction object
}
\description{
Get Granger Causality interactions
}
\examples{
r <- get_sample_recording()
fv_list <- get_filtered_views(r, "Nose", n = 41, p = 3)
jv_sub <- get_joined_view(fv_list)
l <- list(a = c(0, 300), b = c(300, 600), c = c(600, 900))
splicing_df <- splice_time(l)
sv <- get_spliced_view(jv_sub, splicing_df)
g <- get_granger_interactions(sv, c("Nose_x_Central_Sitar", "Nose_x_Central_Tabla"), lag = 1/25)
print(g)
}
\seealso{
Other Granger Causality: 
\code{\link{autoplot.GrangerTime}()},
\code{\link{granger_test}()},
\code{\link{map_to_granger_test}()},
\code{\link{ms_condgrangertest}()},
\code{\link{ms_grangertest1}()},
\code{\link{ms_grangertest2}()},
\code{\link{plot.GrangerInteraction}()},
\code{\link{plot_influence_diagram}()}
}
\concept{Granger Causality}
