% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eightWayPedigreeSingleFunnel.R
\name{eightParentPedigreeSingleFunnel}
\alias{eightParentPedigreeSingleFunnel}
\title{Generate an eight-parent pedigree, using a single funnel}
\usage{
eightParentPedigreeSingleFunnel(
  initialPopulationSize,
  selfingGenerations,
  nSeeds = 1L,
  intercrossingGenerations
)
}
\arguments{
\item{initialPopulationSize}{The number of initially generated lines, whose genetic material is a mosaic of the eight founding lines. These lines are generated using three generations of structured mating.}

\item{selfingGenerations}{The number of selfing generations at the end of the pedigree.}

\item{nSeeds}{The number of progeny taken from each intercrossing line, or from each initially generated line (if no intercrossing is specified). These lines are then selfed according to selfingGenerations.}

\item{intercrossingGenerations}{The number of generations of random mating performed from the F1 generation. Population size is maintained at that specified by initialPopulationSize.}
}
\value{
An object of class \code{detailedPedigree} representing the experimental design, suitable for simulation using simulateMPCross.
}
\description{
Generate a eight-parent pedigree starting from inbred founders, using a single funnel.
}
\examples{
pedigree <- eightParentPedigreeSingleFunnel(initialPopulationSize = 10, 
	selfingGenerations = 0, nSeeds = 1, intercrossingGenerations = 1)
map <- qtl::sim.map()
cross <- simulateMPCross(map = map, pedigree = pedigree, mapFunction = haldane)
#Get out a list of funnels, which are rows of this matrix. For this pedigree, every funnel is 1:8. 
getAllFunnels(cross)
#convert the pedigree to a graph
pedigreeAsGraph <- pedigreeToGraph(pedigree)
#Plot it
\donttest{plot(pedigreeAsGraph)}
#Write it to a file in DOT format
\donttest{igraph::write.graph(graph = pedigreeAsGraph@graph, format = "dot", file = "./pedigree.dot")}
}
\seealso{
\code{\link{eightParentPedigreeSingleFunnel}}, \code{\link{fourParentPedigreeSingleFunnel}}, \code{\link{fourParentPedigreeRandomFunnels}}, \code{\link{twoParentPedigree}}
}
