% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{unzip_data}
\alias{unzip_data}
\title{Unzip m-Path Sense output}
\usage{
unzip_data(path = getwd(), to = NULL, overwrite = FALSE, recursive = TRUE)
}
\arguments{
\item{path}{The path to the directory containing the zip files.}

\item{to}{The output path.}

\item{overwrite}{Logical value whether you want to overwrite already existing zip files.}

\item{recursive}{Logical value indicating whether to unzip files in subdirectories as well. These
files will then be unzipped in their respective subdirectory.}
}
\value{
A message indicating how many files were unzipped.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Similar to \link[utils]{unzip}, but makes it easier to unzip all files in a given path with one
function call.
}
\section{Parallel}{
 This function supports parallel processing in the sense that it is able to
distribute it's computation load among multiple workers. To make use of this functionality, run
\href{https://rdrr.io/cran/future/man/plan.html}{\code{future::plan("multisession")}} before
calling this function.
}

\section{Progress}{
 You can be updated of the progress of this function by using the
\code{\link[progressr:progress]{progressr::progress()}} package. See \code{progressr}'s
\href{https://cran.r-project.org/package=progressr/vignettes/progressr-intro.html}{vignette} on
how to subscribe to these updates.
}

\examples{
\dontrun{
# Unzip all files in a directory
unzip_data(path = "path/to/zipfiles", to = "path/to/unzipped", recursive = FALSE)

# Unzip all files in a directory and its subdirectories
unzip_data(path = "path/to/zipfiles", to = "path/to/unzipped", recursive = TRUE)

# Unzip specific files
unzip_data(
  path = "path/to/zipfiles",
  to = "path/to/unzipped",
  files = c("file1.zip", "file2.zip")
)

# Unzip files in a directory, but skip those that are already unzipped
unzip_data(path = "path/to/zipfiles", to = "path/to/unzipped", overwrite = FALSE)
}
}
