% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_matrix.R
\name{plot_matrix}
\alias{plot_matrix}
\title{Plot a matrix as a heatmap}
\usage{
plot_matrix(mat, zero_na = FALSE, legend = FALSE, na_colour = NA, ...)
}
\arguments{
\item{mat}{A matrix, such as the A matrix of a matrix population model}

\item{zero_na}{Logical indicating whether zero values should be treated as NA}

\item{legend}{Logical indicating whether to include a legend}

\item{na_colour}{Colour for NA values}

\item{...}{Additional arguments to be passed to ggplot}
}
\value{
A ggplot object
}
\description{
Visualise a matrix, such as a matrix population model (MPM), as a heatmap.
}
\examples{
matDim <- 10
A1 <- make_leslie_mpm(
  survival = seq(0.1, 0.7, length.out = matDim),
  fertility = seq(0.1, 0.7, length.out = matDim),
  n_stages = matDim
)
plot_matrix(A1, zero_na = TRUE, na_colour = "black")
plot_matrix(A1, zero_na = TRUE, na_colour = NA)

}
\seealso{
Other utility: 
\code{\link{summarise_mpms}()}
}
\author{
Owen Jones \href{mailto:jones@biology.sdu.dk}{jones@biology.sdu.dk}
}
\concept{utility}
