% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/help.R, R/mpoly.R
\docType{package}
\name{mpoly}
\alias{mpoly}
\alias{package-mpoly}
\alias{mpoly-package}
\title{Multivariate polynomials in R.}
\usage{
mpoly(list, varorder)
}
\arguments{
\item{list}{a list from which to construct an mpoly object}

\item{varorder}{(optional) a character vector setting the
intrinsic variable order of the polynomial}
}
\value{
Object of class mpoly.
}
\description{
A package for symbolic computation and more with multivariate polynomials

mpoly is the most basic function used to create objects of class
mpoly. However, it is not a general purpose function; for that
see mp.
}
\examples{
list <- list(
  c(x = 1, coef = 1, y = 0),
  c(x = 0, y = 1, coef = 2),  
  c(y = 1, coef = -6),  
  c(z = 1, coef = -3, x = 2),  
  c(x = 1, coef = 0, x = 3),
  c(t = 1, coef = 4, t = 2, y = 4),
  c(x = 1),
  c(x = 1),
  c(coef = 5),
  c(coef = 5),
  c(coef = -5)
)

mpoly(list) # 3 x  -  4 y  -  3 x^2 z  +  4 y^4 t^3  +  5
mpoly(list, varorder = c("y", "z", "t", "x"))

list <- list(  c(x = 5, x = 2, coef = 5, coef = 6, y = 0) )
mpoly(list)


}
\seealso{
\code{\link{mp}}
}
\author{
David Kahle \email{david.kahle@gmail.com}
}
