% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_generic_template.R
\name{write_generic_template}
\alias{write_generic_template}
\title{Create generic template}
\usage{
write_generic_template(path_filename)
}
\arguments{
\item{path_filename}{Path to folder where template is generated and user-defined filename}
}
\value{
This function returns a csv-file with the following columns:
\itemize{
\item Run_mpwR - name of file(s).
\item ProteinGroup.IDs_mpwR - ProteinGroup with identifier(s) of protein(s) contained in the protein group.
\item Protein.IDs_mpwR - Protein identifier(s).
\item Peptide.IDs_mpwR - Sequence representation plus possible post-translational modifications.
\item Precursor.IDs_mpwR - Sequence representation plus possible post-translational modifications including charge state.
\item Stripped.Sequence_mpwR - 	The amino acid sequence of the identified peptide without modifications.
\item Precursor.Charge_mpwR - Charge state of the precursor.
\item Missed.Cleavage_mpwR - Number of missed enzymatic cleavages.
\item Retention.time_mpwR -  Retention time in minutes in the elution profile of the precursor ion.
\item ProteinGroup_LFQ_mpwR - LFQ intensity column on proteingroup-level
\item Peptide_LFQ_mpwR - LFQ intensity column on petide-level
}
}
\description{
Generation of a template.csv file for generic input data. The template is provided in long-format.
}
\details{
The generated template.csv file can be used to create a software-independent input file for mpwR. Example entries are provided. The template file - filename_Report.csv - is generated. The appendix "_Report" is required for importing with mpwR. Note that the template is in long-format, so each ProteinGroup.ID has possible multiple entries depending on the number of Precursor.IDs.
}
\examples{
\dontrun{
write_generic_template(path = "DIRECTORY_WHERE_FILE_IS_GENERATED/filename")
}
}
\author{
Oliver Kardell
}
