% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_com.R
\name{sim_com}
\alias{sim_com}
\title{Simulate Community Dynamics Over Time}
\usage{
sim_com(obj, time, burn = 0, progress_bar = TRUE)
}
\arguments{
\item{obj}{An object of class \code{sim_com_data}, as returned by \code{\link[=initialise_com]{initialise_com()}}.}

\item{time}{Integer. Total number of simulation steps. Must be >= 2.}

\item{burn}{Integer. Number of initial burn-in steps to exclude from the output. Must be >= 0 and < \code{time}.}

\item{progress_bar}{Logical. Whether to display a progress bar during the simulation.}
}
\value{
An object of class \code{sim_com_results}, a list containing:
\describe{
\item{extinction}{Named logical vector indicating species that went extinct.}
\item{sim_time}{Integer. Duration of the output simulation (excluding burn-in).}
\item{id}{A \code{\link[terra:SpatRaster-class]{SpatRaster}} object used as a geographic template.}
\item{N_map}{4D array [rows, cols, time, species] of population abundances.}
}
}
\description{
This function simulates species interactions and population dynamics over a given period.
It accounts for species invasions and updates population abundances at each time step.
}
\examples{
\donttest{
# Read community data from the mrangr package
community <- get_community()

# Simulation
simulated_com_01 <- sim_com(obj = community, time = 10)

# Simulation with burned time steps
simulated_com_02 <- sim_com(obj = community, time = 10, burn = 3)
}

}
