% Generated by roxygen2 (4.0.2): do not edit by hand
\name{getpar}
\alias{getpar}
\title{Extraction and assignment of parameters to vector}
\usage{
getpar(ddfobj, fitting = "all", index = FALSE)
}
\arguments{
\item{ddfobj}{distance sampling object (see \code{\link{create.ddfobj}})}

\item{fitting}{character string which is either "all","key","adjust" which
determines which parameters are retrieved}

\item{index}{logical that determines whether parameters are returned (FALSE)
or starting indices in parameter vector for scale, shape, adjustment
parameters}
}
\value{
index==FALSE, vector of parameters that were requested or
  index==TRUE, vector of 3 indices for scale, shape, adjustment
}
\description{
Extracts parameters of a particular type (scale,
shape, adjustments or g0 (p(0))) from the vector of parameters in
\code{ddfobj}. All of the parameters are kept in a single vector for
optimization even though they have very different uses.  \code{assign.par}
parses them from the vector based on a known structure and assigns them into
\code{ddfobj}.  \code{getpar} extracts the requested types to be extracted
from \code{ddfobj}.
}
\note{
Internal functions not intended to be called by user.
}
\author{
Jeff Laake
}
\seealso{
assign.par
}
\keyword{utility}

