% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mr_names2.R
\name{mr_names}
\alias{mr_names}
\title{Get region names - v2}
\usage{
mr_names(layer, ...)
}
\arguments{
\item{layer}{A layer name, one of MarineRegions:eez,
MarineRegions:eez_boundaries, MarineRegions:iho, MarineRegions:fao,
or MarineRegions:lme}

\item{...}{Curl options passed on to \code{\link[httr]{GET}}}
}
\value{
a data.frame, or tibble, of class tbl_df (basically, a compact
data.frame), with slots:
\itemize{
 \item layer (character) - name of the layer (e.g. MarineRegions:eez)
 \item name_first (character) - first part of the name, e.g., MarineRegions
 \item name_second (character) - second part of the name, e.g., eez
 \item id (character) - the feature ID
}
additional columns vary by layer
}
\description{
Get region names - v2
}
\examples{
\dontrun{
# mr_names gives a tidy data.frame
(res <- mr_names("MarineRegions:eez"))
(res <- mr_names('MarineRegions:eez_boundaries'))
(res <- mr_names('MarineRegions:iho'))
(res <- mr_names('MarineRegions:fao'))
(res <- mr_names('MarineRegions:lme'))
}
}

